/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Addresses {
    public static String getAnyAddress() {
        SortedSet<String> a = Addresses.getAddresses();
        if (!a.isEmpty()) {
            return a.first();
        }
        return null;
    }

    public static SortedSet<String> getAddresses() {
        return Addresses.getAddresses(false, false);
    }

    public static SortedSet<String> getAllAddresses() {
        return Addresses.getAddresses(true, true);
    }

    public static SortedSet<String> getAddresses(boolean includeLocal, boolean includeIPv6) {
        boolean haveIPv4 = false;
        boolean haveIPv6 = false;
        TreeSet<String> rv = new TreeSet<String>();
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            InetAddress[] allMyIps = InetAddress.getAllByName(localhost.getCanonicalHostName());
            if (allMyIps != null) {
                for (int i = 0; i < allMyIps.length; ++i) {
                    if (allMyIps[i] instanceof Inet4Address) {
                        haveIPv4 = true;
                    } else {
                        haveIPv6 = true;
                    }
                    if (!Addresses.shouldInclude(allMyIps[i], includeLocal, includeIPv6)) continue;
                    rv.add(allMyIps[i].getHostAddress());
                }
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> ifcs = NetworkInterface.getNetworkInterfaces();
            while (ifcs.hasMoreElements()) {
                NetworkInterface ifc = ifcs.nextElement();
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (addr instanceof Inet4Address) {
                        haveIPv4 = true;
                    } else {
                        haveIPv6 = true;
                    }
                    if (!Addresses.shouldInclude(addr, includeLocal, includeIPv6)) continue;
                    rv.add(addr.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            // empty catch block
        }
        if (includeLocal && haveIPv4) {
            rv.add("0.0.0.0");
        }
        if (includeLocal && includeIPv6 && haveIPv6) {
            rv.add("0:0:0:0:0:0:0:0");
        }
        return rv;
    }

    private static boolean shouldInclude(InetAddress ia, boolean includeLocal, boolean includeIPv6) {
        return !(ia.isLinkLocalAddress() || ia.isMulticastAddress() || !includeLocal && (ia.isAnyLocalAddress() || ia.isLoopbackAddress() || ia.isSiteLocalAddress()) || !includeLocal && ia.getHostAddress().startsWith("5.") || !includeIPv6 && !(ia instanceof Inet4Address));
    }

    public static void main(String[] args) {
        System.err.println("External Addresses:");
        SortedSet<String> a = Addresses.getAddresses(false, false);
        for (String s : a) {
            System.err.println(s);
        }
        System.err.println("All addresses:");
        a = Addresses.getAddresses(true, true);
        for (String s : a) {
            System.err.println(s);
        }
    }
}

