/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.SDSCache;
import net.i2p.data.SimpleDataStructure;

public class Hash
extends SimpleDataStructure {
    private volatile String _stringified;
    private volatile String _base64ed;
    private int _cachedHashCode;
    public static final int HASH_LENGTH = 32;
    public static final Hash FAKE_HASH = new Hash(new byte[32]);
    private static final int CACHE_SIZE = 2048;
    private static final SDSCache<Hash> _cache = new SDSCache<Hash>(Hash.class, 32, 2048);

    public static Hash create(byte[] data) {
        return _cache.get(data);
    }

    public static Hash create(byte[] data, int off) {
        return _cache.get(data, off);
    }

    public static Hash create(InputStream in) throws IOException {
        return _cache.get(in);
    }

    public Hash() {
    }

    public Hash(byte[] data) {
        this.setData(data);
    }

    public int length() {
        return 32;
    }

    public void setData(byte[] data) {
        super.setData(data);
        this._stringified = null;
        this._base64ed = null;
        this._cachedHashCode = super.hashCode();
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        super.readBytes(in);
        this._stringified = null;
        this._base64ed = null;
        this._cachedHashCode = super.hashCode();
    }

    public int hashCode() {
        return this._cachedHashCode;
    }

    public String toBase64() {
        if (this._base64ed == null) {
            this._base64ed = super.toBase64();
        }
        return this._base64ed;
    }
}

