/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.math.BigInteger;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CryptoConstants;
import net.i2p.util.Clock;
import net.i2p.util.I2PThread;
import net.i2p.util.NativeBigInteger;

class YKGenerator {
    private static final int MIN_NUM_BUILDERS;
    private static final int MAX_NUM_BUILDERS;
    private static final int CALC_DELAY;
    private static final LinkedBlockingQueue<BigInteger[]> _values;
    private static final Thread _precalcThread;
    private static final I2PAppContext ctx;
    public static final String PROP_YK_PRECALC_MIN = "crypto.yk.precalc.min";
    public static final String PROP_YK_PRECALC_MAX = "crypto.yk.precalc.max";
    public static final String PROP_YK_PRECALC_DELAY = "crypto.yk.precalc.delay";
    public static final int DEFAULT_YK_PRECALC_MIN = 20;
    public static final int DEFAULT_YK_PRECALC_MAX = 50;
    public static final int DEFAULT_YK_PRECALC_DELAY = 200;
    private static long _checkDelay;
    private static final BigInteger _two;

    YKGenerator() {
    }

    private static final int getSize() {
        return _values.size();
    }

    private static final boolean addValues(BigInteger[] yk) {
        return _values.offer(yk);
    }

    public static BigInteger[] getNextYK() {
        ctx.statManager().addRateData("crypto.YKUsed", 1L, 0L);
        BigInteger[] rv = _values.poll();
        if (rv != null) {
            return rv;
        }
        ctx.statManager().addRateData("crypto.YKEmpty", 1L, 0L);
        return YKGenerator.generateYK();
    }

    private static final BigInteger[] generateYK() {
        NativeBigInteger k = null;
        BigInteger y = null;
        while (k == null) {
            k = new NativeBigInteger(226, ctx.random());
            if (BigInteger.ZERO.compareTo(k) == 0) {
                k = null;
                continue;
            }
            BigInteger kPlus2 = k.add(_two);
            if (kPlus2.compareTo(CryptoConstants.elgp) <= 0) continue;
            k = null;
        }
        y = CryptoConstants.elgg.modPow(k, CryptoConstants.elgp);
        BigInteger[] yk = new BigInteger[]{y, k};
        return yk;
    }

    public static void main(String[] args) {
        System.out.println("\n\n\n\nBegin test\n");
        long negTime = 0L;
        for (int i = 0; i < 5; ++i) {
            long startNeg = Clock.getInstance().now();
            YKGenerator.getNextYK();
            long endNeg = Clock.getInstance().now();
            negTime += endNeg - startNeg;
        }
        System.out.println("YK fetch time for 5 runs: " + negTime + " @ " + negTime / 5L + "ms each");
    }

    static {
        _checkDelay = 30000L;
        ctx = I2PAppContext.getGlobalContext();
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x7F00000L;
        }
        int factor = (int)Math.max(1L, Math.min(8L, 1L + maxMemory / 0x8000000L));
        int defaultMin = 20 * factor;
        int defaultMax = 50 * factor;
        MIN_NUM_BUILDERS = ctx.getProperty(PROP_YK_PRECALC_MIN, defaultMin);
        MAX_NUM_BUILDERS = ctx.getProperty(PROP_YK_PRECALC_MAX, defaultMax);
        CALC_DELAY = ctx.getProperty(PROP_YK_PRECALC_DELAY, 200);
        _values = new LinkedBlockingQueue(MAX_NUM_BUILDERS);
        ctx.statManager().createRateStat("crypto.YKUsed", "Need a YK from the queue", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.YKEmpty", "YK queue empty", "Encryption", new long[]{3600000L});
        _precalcThread = new I2PThread(new YKPrecalcRunner(MIN_NUM_BUILDERS, MAX_NUM_BUILDERS));
        _precalcThread.setName("YK Precalc");
        _precalcThread.setDaemon(true);
        _precalcThread.setPriority(1);
        _precalcThread.start();
        _two = new NativeBigInteger(1, new byte[]{2});
    }

    private static class YKPrecalcRunner
    implements Runnable {
        private final int _minSize;
        private final int _maxSize;

        private YKPrecalcRunner(int minSize, int maxSize) {
            this._minSize = minSize;
            this._maxSize = maxSize;
        }

        public void run() {
            while (true) {
                int curSize = 0;
                int startSize = YKGenerator.getSize();
                if (startSize <= this._minSize * 2 / 3 && _checkDelay > 1000L) {
                    _checkDelay -= 1000L;
                } else if (startSize > this._minSize * 3 / 2 && _checkDelay < 60000L) {
                    _checkDelay += 1000L;
                }
                curSize = startSize;
                if (curSize < this._minSize) {
                    for (int i = curSize; i < this._maxSize && YKGenerator.addValues(YKGenerator.generateYK()); ++i) {
                        try {
                            Thread.sleep(CALC_DELAY);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                }
                try {
                    Thread.sleep(_checkDelay);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

