/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import gnu.crypto.hash.Sha256Standalone;
import net.i2p.I2PAppContext;
import net.i2p.crypto.HMACGenerator;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.I2PHMac;

public class HMAC256Generator
extends HMACGenerator {
    public HMAC256Generator(I2PAppContext context) {
        super(context);
    }

    protected I2PHMac acquire() {
        I2PHMac rv = (I2PHMac)this._available.poll();
        if (rv != null) {
            return rv;
        }
        return new I2PHMac(new Sha256ForMAC());
    }

    private class Sha256ForMAC
    extends Sha256Standalone
    implements Digest {
        private Sha256ForMAC() {
        }

        public String getAlgorithmName() {
            return "sha256 for hmac";
        }

        public int getDigestSize() {
            return 32;
        }

        public int doFinal(byte[] out, int outOff) {
            byte[] rv = this.digest();
            System.arraycopy(rv, 0, out, outOff, rv.length);
            this.reset();
            return rv.length;
        }
    }
}

