/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;

public class DHSessionKeyBuilder {
    private static final I2PAppContext _context = I2PAppContext.getGlobalContext();
    private static final Log _log;
    private static final int MIN_NUM_BUILDERS;
    private static final int MAX_NUM_BUILDERS;
    private static final int CALC_DELAY;
    private static final LinkedBlockingQueue<DHSessionKeyBuilder> _builders;
    private static final Thread _precalcThread;
    private BigInteger _myPrivateValue;
    private BigInteger _myPublicValue;
    private BigInteger _peerValue;
    private SessionKey _sessionKey;
    private ByteArray _extraExchangedBytes;
    public static final String PROP_DH_PRECALC_MIN = "crypto.dh.precalc.min";
    public static final String PROP_DH_PRECALC_MAX = "crypto.dh.precalc.max";
    public static final String PROP_DH_PRECALC_DELAY = "crypto.dh.precalc.delay";
    public static final int DEFAULT_DH_PRECALC_MIN = 15;
    public static final int DEFAULT_DH_PRECALC_MAX = 40;
    public static final int DEFAULT_DH_PRECALC_DELAY = 200;
    private static long _checkDelay;

    public DHSessionKeyBuilder() {
        _context.statManager().addRateData("crypto.DHUsed", 1L, 0L);
        DHSessionKeyBuilder builder = _builders.poll();
        if (builder != null) {
            if (_log.shouldLog(10)) {
                _log.debug("Removing a builder.  # left = " + _builders.size());
            }
            this._myPrivateValue = builder._myPrivateValue;
            this._myPublicValue = builder._myPublicValue;
            this._extraExchangedBytes = builder._extraExchangedBytes;
        } else {
            if (_log.shouldLog(20)) {
                _log.info("No more builders, creating one now");
            }
            _context.statManager().addRateData("crypto.DHEmpty", 1L, 0L);
            this._myPublicValue = this.generateMyValue();
            this._extraExchangedBytes = new ByteArray();
        }
    }

    private DHSessionKeyBuilder(boolean usePool) {
        this._extraExchangedBytes = new ByteArray();
    }

    public static DHSessionKeyBuilder exchangeKeys(InputStream in, OutputStream out) throws IOException {
        DHSessionKeyBuilder builder = new DHSessionKeyBuilder();
        DHSessionKeyBuilder.writeBigI(out, builder.getMyPublicValue());
        BigInteger Y = DHSessionKeyBuilder.readBigI(in);
        if (Y == null) {
            return null;
        }
        try {
            builder.setPeerPublicValue(Y);
            return builder;
        }
        catch (InvalidPublicParameterException ippe) {
            if (_log.shouldLog(40)) {
                _log.error("Key exchange failed (hostile peer?)", ippe);
            }
            return null;
        }
    }

    static BigInteger readBigI(InputStream in) throws IOException {
        byte[] Y = new byte[256];
        int read = DataHelper.read(in, Y);
        if (read != 256) {
            return null;
        }
        if (1 == (Y[0] & 0x80)) {
            if (_log.shouldLog(10)) {
                _log.debug("High bit set");
            }
            byte[] Y2 = new byte[257];
            System.arraycopy(Y, 0, Y2, 1, 256);
            Y = Y2;
        }
        return new NativeBigInteger(1, Y);
    }

    static void writeBigI(OutputStream out, BigInteger val) throws IOException {
        byte[] x = val.toByteArray();
        for (int i = x.length; i < 256; ++i) {
            out.write(0);
        }
        if (x.length == 257) {
            out.write(x, 1, 256);
        } else if (x.length == 256) {
            out.write(x);
        } else if (x.length > 257) {
            throw new IllegalArgumentException("Value is too large!  length=" + x.length);
        }
        out.flush();
    }

    private static final int getSize() {
        return _builders.size();
    }

    private static final boolean addBuilder(DHSessionKeyBuilder builder) {
        return _builders.offer(builder);
    }

    public BigInteger generateMyValue() {
        long start = System.currentTimeMillis();
        this._myPrivateValue = new NativeBigInteger(226, _context.random());
        BigInteger myValue = CryptoConstants.elgg.modPow(this._myPrivateValue, CryptoConstants.elgp);
        long end = System.currentTimeMillis();
        long diff = end - start;
        _context.statManager().addRateData("crypto.dhGeneratePublicTime", diff, diff);
        if (diff > 1000L) {
            if (_log.shouldLog(30)) {
                _log.warn("Took more than a second (" + diff + "ms) to generate local DH value");
            }
        } else if (_log.shouldLog(10)) {
            _log.debug("Took " + diff + "ms to generate local DH value");
        }
        return myValue;
    }

    public BigInteger getMyPrivateValue() {
        return this._myPrivateValue;
    }

    public BigInteger getMyPublicValue() {
        if (this._myPublicValue == null) {
            this._myPublicValue = this.generateMyValue();
        }
        return this._myPublicValue;
    }

    public byte[] getMyPublicValueBytes() {
        return DHSessionKeyBuilder.toByteArray(this.getMyPublicValue());
    }

    private static final byte[] toByteArray(BigInteger bi) {
        byte[] data = bi.toByteArray();
        byte[] rv = new byte[256];
        if (data.length == 257) {
            System.arraycopy(data, 1, rv, 0, rv.length);
        } else if (data.length == 256) {
            System.arraycopy(data, 0, rv, 0, rv.length);
        } else {
            System.arraycopy(data, 0, rv, rv.length - data.length, data.length);
        }
        return rv;
    }

    public void setPeerPublicValue(BigInteger peerVal) throws InvalidPublicParameterException {
        DHSessionKeyBuilder.validatePublic(peerVal);
        this._peerValue = peerVal;
    }

    public void setPeerPublicValue(byte[] val) throws InvalidPublicParameterException {
        if (val.length != 256) {
            throw new IllegalArgumentException("Peer public value must be exactly 256 bytes");
        }
        if (1 == (val[0] & 0x80)) {
            if (_log.shouldLog(10)) {
                _log.debug("High bit set");
            }
            byte[] val2 = new byte[257];
            System.arraycopy(val, 0, val2, 1, 256);
            val = val2;
        }
        this.setPeerPublicValue(new NativeBigInteger(1, val));
    }

    public BigInteger getPeerPublicValue() {
        return this._peerValue;
    }

    public byte[] getPeerPublicValueBytes() {
        return DHSessionKeyBuilder.toByteArray(this.getPeerPublicValue());
    }

    public SessionKey getSessionKey() {
        if (this._sessionKey != null) {
            return this._sessionKey;
        }
        if (this._peerValue != null) {
            if (this._myPrivateValue == null) {
                this.generateMyValue();
            }
            this._sessionKey = this.calculateSessionKey(this._myPrivateValue, this._peerValue);
        }
        return this._sessionKey;
    }

    public ByteArray getExtraBytes() {
        return this._extraExchangedBytes;
    }

    private final SessionKey calculateSessionKey(BigInteger myPrivateValue, BigInteger publicPeerValue) {
        byte[] remaining;
        byte[] val;
        long start = System.currentTimeMillis();
        SessionKey key = new SessionKey();
        BigInteger exchangedKey = publicPeerValue.modPow(myPrivateValue, CryptoConstants.elgp);
        byte[] buf = exchangedKey.toByteArray();
        if (buf.length < (val = new byte[32]).length) {
            System.arraycopy(buf, 0, val, 0, buf.length);
            remaining = SHA256Generator.getInstance().calculateHash(val).getData();
            this._extraExchangedBytes.setData(remaining);
            if (_log.shouldLog(10)) {
                _log.debug("Storing " + remaining.length + " bytes from the DH exchange by SHA256 the session key");
            }
        } else {
            System.arraycopy(buf, 0, val, 0, val.length);
            _context.random().harvester().feedEntropy("DH", buf, val.length, buf.length - val.length);
            remaining = new byte[buf.length - val.length];
            System.arraycopy(buf, val.length, remaining, 0, remaining.length);
            this._extraExchangedBytes.setData(remaining);
            if (_log.shouldLog(10)) {
                _log.debug("Storing " + remaining.length + " bytes from the end of the DH exchange");
            }
        }
        key.setData(val);
        long end = System.currentTimeMillis();
        long diff = end - start;
        _context.statManager().addRateData("crypto.dhCalculateSessionTime", diff, diff);
        if (diff > 1000L) {
            if (_log.shouldLog(30)) {
                _log.warn("Generating session key took too long (" + diff + " ms");
            }
        } else if (_log.shouldLog(10)) {
            _log.debug("Generating session key " + diff + " ms");
        }
        return key;
    }

    private static final void validatePublic(BigInteger publicValue) throws InvalidPublicParameterException {
        int cmp = publicValue.compareTo(NativeBigInteger.ONE);
        if (cmp <= 0) {
            throw new InvalidPublicParameterException("Public value is below two: " + publicValue.toString());
        }
        cmp = publicValue.compareTo(CryptoConstants.elgp);
        if (cmp >= 0) {
            throw new InvalidPublicParameterException("Public value is above p-1: " + publicValue.toString());
        }
    }

    static {
        _checkDelay = 30000L;
        I2PAppContext ctx = _context;
        _log = ctx.logManager().getLog(DHSessionKeyBuilder.class);
        ctx.statManager().createRateStat("crypto.dhGeneratePublicTime", "How long it takes to create x and X", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.dhCalculateSessionTime", "How long it takes to create the session key", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.DHUsed", "Need a DH from the queue", "Encryption", new long[]{3600000L});
        ctx.statManager().createRateStat("crypto.DHEmpty", "DH queue empty", "Encryption", new long[]{3600000L});
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory == Long.MAX_VALUE) {
            maxMemory = 0x7F00000L;
        }
        int factor = (int)Math.max(1L, Math.min(4L, 1L + maxMemory / 0x8000000L));
        int defaultMin = 15 * factor;
        int defaultMax = 40 * factor;
        MIN_NUM_BUILDERS = ctx.getProperty(PROP_DH_PRECALC_MIN, defaultMin);
        MAX_NUM_BUILDERS = ctx.getProperty(PROP_DH_PRECALC_MAX, defaultMax);
        CALC_DELAY = ctx.getProperty(PROP_DH_PRECALC_DELAY, 200);
        _builders = new LinkedBlockingQueue(MAX_NUM_BUILDERS);
        if (_log.shouldLog(10)) {
            _log.debug("DH Precalc (minimum: " + MIN_NUM_BUILDERS + " max: " + MAX_NUM_BUILDERS + ", delay: " + CALC_DELAY + ")");
        }
        _precalcThread = new I2PThread(new DHSessionKeyBuilderPrecalcRunner(MIN_NUM_BUILDERS, MAX_NUM_BUILDERS));
        _precalcThread.setName("DH Precalc");
        _precalcThread.setDaemon(true);
        _precalcThread.setPriority(1);
        _precalcThread.start();
    }

    public static class InvalidPublicParameterException
    extends I2PException {
        public InvalidPublicParameterException() {
        }

        public InvalidPublicParameterException(String msg) {
            super(msg);
        }
    }

    private static class DHSessionKeyBuilderPrecalcRunner
    implements Runnable {
        private final int _minSize;
        private final int _maxSize;

        private DHSessionKeyBuilderPrecalcRunner(int minSize, int maxSize) {
            this._minSize = minSize;
            this._maxSize = maxSize;
        }

        public void run() {
            while (true) {
                int curSize = 0;
                long start = System.currentTimeMillis();
                int startSize = DHSessionKeyBuilder.getSize();
                if (startSize <= this._minSize * 2 / 3 && _checkDelay > 1000L) {
                    _checkDelay -= 1000L;
                } else if (startSize > this._minSize * 3 / 2 && _checkDelay < 60000L) {
                    _checkDelay += 1000L;
                }
                curSize = startSize;
                if (curSize < this._minSize) {
                    for (int i = curSize; i < this._maxSize; ++i) {
                        long curStart = System.currentTimeMillis();
                        if (!DHSessionKeyBuilder.addBuilder(DHSessionKeyBuilderPrecalcRunner.precalc())) break;
                        long curCalc = System.currentTimeMillis() - curStart;
                        try {
                            Thread.sleep((long)CALC_DELAY + curCalc * 3L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                }
                long end = System.currentTimeMillis();
                int numCalc = curSize - startSize;
                if (numCalc > 0 && _log.shouldLog(10)) {
                    _log.debug("Precalced " + numCalc + " to " + curSize + " in " + (end - start - (long)(CALC_DELAY * numCalc)) + "ms (not counting " + CALC_DELAY * numCalc + "ms relief).  now sleeping");
                }
                try {
                    Thread.sleep(_checkDelay);
                }
                catch (InterruptedException ie) {
                }
            }
        }

        private static DHSessionKeyBuilder precalc() {
            DHSessionKeyBuilder builder = new DHSessionKeyBuilder(false);
            builder.getMyPublicValue();
            return builder;
        }
    }
}

