/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.InputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSimpleClient;
import net.i2p.data.Base32;
import net.i2p.data.Destination;
import net.i2p.data.Hash;

class LookupDest {
    protected LookupDest(I2PAppContext context) {
    }

    static Destination lookupBase32Hash(I2PAppContext ctx, String key) {
        byte[] h = Base32.decode(key);
        if (h == null) {
            return null;
        }
        return LookupDest.lookupHash(ctx, h);
    }

    static Destination lookupHash(I2PAppContext ctx, byte[] h) {
        Hash key = Hash.create(h);
        Destination rv = null;
        try {
            I2PSimpleClient client = new I2PSimpleClient();
            Properties opts = new Properties();
            String s = ctx.getProperty("i2cp.tcp.host");
            if (s != null) {
                opts.put("i2cp.tcp.host", s);
            }
            if ((s = ctx.getProperty("i2cp.tcp.port")) != null) {
                opts.put("i2cp.tcp.port", s);
            }
            I2PSession session = client.createSession((InputStream)null, opts);
            session.connect();
            rv = session.lookupDest(key);
            session.destroySession();
        }
        catch (I2PSessionException ise) {
            // empty catch block
        }
        return rv;
    }

    public static void main(String[] args) {
        Destination dest = LookupDest.lookupBase32Hash(I2PAppContext.getGlobalContext(), args[0]);
        if (dest == null) {
            System.out.println("Destination not found!");
        } else {
            System.out.println(dest.toBase64());
        }
    }
}

