/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import edu.umd.cs.findbugs.anttask.AbstractFindBugsTask;
import edu.umd.cs.findbugs.anttask.DataFile;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;

public class ComputeBugHistoryTask
extends AbstractFindBugsTask {
    private File outputFile;
    private boolean overrideRevisionNames;
    private boolean noPackageMoves;
    private boolean preciseMatch;
    private boolean precisePriorityMatch;
    private boolean quiet;
    private boolean withMessages;
    private List<DataFile> dataFileList = new LinkedList<DataFile>();

    public ComputeBugHistoryTask() {
        super("edu.umd.cs.findbugs.workflow.Update");
        this.setFailOnError(true);
    }

    public void setOutput(File arg) {
        this.outputFile = arg;
    }

    public void setOverrideRevisionNames(boolean arg) {
        this.overrideRevisionNames = arg;
    }

    public void setNoPackageMoves(boolean arg) {
        this.noPackageMoves = arg;
    }

    public void setPreciseMatch(boolean arg) {
        this.preciseMatch = arg;
    }

    public void setPrecisePriorityMatch(boolean arg) {
        this.precisePriorityMatch = arg;
    }

    public void setQuiet(boolean arg) {
        this.quiet = arg;
    }

    public void setWithMessages(boolean arg) {
        this.withMessages = arg;
    }

    public DataFile createDataFile() {
        DataFile dataFile = new DataFile();
        this.dataFileList.add(dataFile);
        return dataFile;
    }

    protected void checkParameters() {
        super.checkParameters();
        if (this.outputFile == null) {
            throw new BuildException("outputFile attribute must be set", this.getLocation());
        }
    }

    protected void configureFindbugsEngine() {
        this.addArg("-output");
        this.addArg(this.outputFile.getPath());
        if (this.overrideRevisionNames) {
            this.addArg("-overrideRevisionNames");
        }
        if (this.noPackageMoves) {
            this.addArg("-noPackageMoves");
        }
        if (this.preciseMatch) {
            this.addArg("-preciseMatch");
        }
        if (this.precisePriorityMatch) {
            this.addArg("-precisePriorityMatch");
        }
        if (this.quiet) {
            this.addArg("-quiet");
        }
        if (this.withMessages) {
            this.addArg("-withMessages");
        }
        for (DataFile dataFile : this.dataFileList) {
            this.addArg(dataFile.getName());
        }
    }

    protected void beforeExecuteJavaProcess() {
        this.log("Running computeBugHistory...");
    }

    protected void afterExecuteJavaProcess(int rc) {
        if (rc != 0) {
            throw new BuildException("execution of " + this.getTaskName() + " failed");
        }
        this.log("History database written to " + this.outputFile.getPath());
    }
}

