/*
 * Decompiled with CFR 0.152.
 */
package org.jvyaml;

import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jvyaml.Composer;
import org.jvyaml.ComposerImpl;
import org.jvyaml.Constructor;
import org.jvyaml.ParserImpl;
import org.jvyaml.ResolverImpl;
import org.jvyaml.SafeConstructorImpl;
import org.jvyaml.ScannerImpl;

public class ConstructorImpl
extends SafeConstructorImpl {
    private static final Map yamlConstructors = new HashMap();
    private static final Map yamlMultiConstructors = new HashMap();
    private static final Map yamlMultiRegexps = new HashMap();

    public Constructor.YamlConstructor getYamlConstructor(Object key) {
        Constructor.YamlConstructor mine = (Constructor.YamlConstructor)yamlConstructors.get(key);
        if (mine == null) {
            mine = super.getYamlConstructor(key);
        }
        return mine;
    }

    public Constructor.YamlMultiConstructor getYamlMultiConstructor(Object key) {
        Constructor.YamlMultiConstructor mine = (Constructor.YamlMultiConstructor)yamlMultiConstructors.get(key);
        if (mine == null) {
            mine = super.getYamlMultiConstructor(key);
        }
        return mine;
    }

    public Pattern getYamlMultiRegexp(Object key) {
        Pattern mine = (Pattern)yamlMultiRegexps.get(key);
        if (mine == null) {
            mine = super.getYamlMultiRegexp(key);
        }
        return mine;
    }

    public Set getYamlMultiRegexps() {
        HashSet all = new HashSet(super.getYamlMultiRegexps());
        all.addAll(yamlMultiRegexps.keySet());
        return all;
    }

    public static void addConstructor(String tag, Constructor.YamlConstructor ctor) {
        yamlConstructors.put(tag, ctor);
    }

    public static void addMultiConstructor(String tagPrefix, Constructor.YamlMultiConstructor ctor) {
        yamlMultiConstructors.put(tagPrefix, ctor);
        yamlMultiRegexps.put(tagPrefix, Pattern.compile("^" + tagPrefix));
    }

    public ConstructorImpl(Composer composer) {
        super(composer);
    }

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        System.out.println("Reading of file: \"" + filename + "\"");
        StringBuffer input = new StringBuffer();
        FileReader reader = new FileReader(filename);
        char[] buff = new char[1024];
        int read = 0;
        do {
            read = reader.read(buff);
            input.append(buff, 0, read);
        } while (read >= 1024);
        ((Reader)reader).close();
        String str = input.toString();
        long before = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            ConstructorImpl ctor = new ConstructorImpl(new ComposerImpl(new ParserImpl(new ScannerImpl(str)), new ResolverImpl()));
            Iterator iter = ctor.eachDocument();
            while (iter.hasNext()) {
                System.out.println(iter.next());
                iter.next();
            }
        }
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Walking through the nodes for the file: " + filename + " took " + time + "ms, or " + timeS + " seconds");
    }
}

