/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is infoRSS.
 *
 * The Initial Developer of the Original Code is
 *   Didier Ernotte <didier@ernotte.com>.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Didier Ernotte <didier@ernotte.com>.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
//-------------------------------------------------------------------------------------------------------------
// inforssFeedManager
// Author : Didier Ernotte 2005
// Inforss extension
//-------------------------------------------------------------------------------------------------------------
function inforssFeedManager(mediator)
{
  this.mediator = mediator;
  this.rdfRepository = new inforssRDFRepository();
  return this;
}

inforssFeedManager.prototype =
{
  infoList : new Array(),
  mediator : null,
  selectedInfo : null,
  rdfRepository : null,
  cycleGroup : null,
  emptyFeedMarker : null,
  direction : null,

//-------------------------------------------------------------------------------------------------------------
  init : function()
  {
    inforssTraceIn(this);
    try
    {
      inforssRead(true, true);
      this.rdfRepository.init();
      var oldSelected = this.selectedInfo;
      this.selectedInfo = null;
      for (var i=0; i< this.infoList.length; i++)
      {
        this.infoList[i].reset();
      }
      var selectedInfo = this.getSelectedInfo(true);
      if (selectedInfo != null)
      {
        if ((oldSelected != null) && (oldSelected.getUrl() != selectedInfo.getUrl()))
        {
          oldSelected.passivate();
        }
//dump("selectedInfo <> null\n");
//dump("url=" + selectedInfo.getUrl() + "\n");
        inforssHeadlineDisplay.setBackgroundColor(selectedInfo.menuItem, false);
        
//        selectedInfo.reset();
        if (inforssXMLRepository.isActive() == true)
        {
//dump("activate dans le init du FM\n");
          selectedInfo.activate();
          if (selectedInfo.getType() == "group")
          {
            this.mediator.updateMenuIcon(selectedInfo);
          }
        }
        else
        {
          selectedInfo.passivate();
        }
      }
      this.mediator.refreshBar();
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
  },


//-------------------------------------------------------------------------------------------------------------
  sync : function(url)
  {
    inforssTraceIn(this);
    try
    {
      var info = this.locateFeed(url).info;
      if ((info != null) && (info.insync == false) && (info.headlines != null) && (info.headlines.length > 0) &&
          (info.reload == false))
      {
        var data = info.getXmlHeadlines();
        var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);
        observerService.notifyObservers(null, "syncBack", data);
      }
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
  },

//-------------------------------------------------------------------------------------------------------------
  syncBack : function(data)
  {
    inforssTraceIn(this);
    try
    {
      var objDOMParser = new DOMParser();
      var objDoc = objDOMParser.parseFromString(data, "text/xml");

      var url = objDoc.firstChild.getAttribute("url");
      var info = this.locateFeed(url).info;

      if ((info != null) && (info.insync == true))
      {
        info.synchronize(objDoc);
      }
      delete objDoc;
      delete objDOMParser;
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
  },

//-------------------------------------------------------------------------------------------------------------
  getSelectedInfo : function(findDefault)
  {
    inforssTraceIn(this);
    try
    {
      if (this.selectedInfo == null)
      {
        var info = null;
        var find = false;
        var i = 0;
        while ((i < this.infoList.length) && (find == false))
        {
          if (this.infoList[i].isSelected() == true)
          {
            find = true;
            info = this.infoList[i];
            info.select();
//dump("getSelectedInfo=" + info.getUrl() + "\n");
          }
          else
          {
            i++;
          }
        }
        if ((find == false) && (this.infoList.length > 0) && (findDefault == true))
        {
//alert("getSelectedInfo find == false");
          info = this.infoList[0];
          info.select();
        }
        this.selectedInfo = info;
      }
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
    return this.selectedInfo;
  },

//-------------------------------------------------------------------------------------------------------------
  signalReadEnd : function(feed)
  {
    this.rdfRepository.flush();
    this.mediator.updateBar(feed);
  },

//-------------------------------------------------------------------------------------------------------------
  passivateOldSelected : function()
  {
    try
    {
      var selectedInfo = this.getSelectedInfo(false);
      if (selectedInfo != null)
      {
        selectedInfo.unselect();
        inforssHeadlineDisplay.setDefaultBackgroundColor(selectedInfo.menuItem, false);
        selectedInfo.passivate();
      }
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
  },

//-------------------------------------------------------------------------------------------------------------
  addFeed : function(feedXML, menuItem)
  {
    inforssTraceIn(this);
    try
    {
      var oldFeed = this.locateFeed(feedXML.getAttribute("url")).info;
      if (oldFeed == null)
      {
        var info = inforssInformation.createInfoFactory(feedXML, this, menuItem);
        this.infoList.push(info);
      }
      else
      {
//if (feedXML.getAttribute("type") == "group")
//{
//dump("addFeed GROUP " + feedXML.getElementsByTagName("GROUP").length + "\n");
//}
        oldFeed.feedXML = feedXML;
        oldFeed.menuItem = menuItem;
      }
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
  },

//-------------------------------------------------------------------------------------------------------------
  locateFeed : function(url)
  {
    inforssTraceIn(this);
    try
    {
      var find = false;
      var info = null;
      var i = 0;
      while ((i < this.infoList.length) && (find == false))
      {
        if (this.infoList[i].getUrl() == url)
        {
          find = true;
          info = this.infoList[i];
        }
        else
        {
          i++;
        }
      }
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
    return { info: info, index: i };
  },

//-------------------------------------------------------------------------------------------------------------
  setSelected : function(url)
  {
    inforssTraceIn(this);
    try
    {
      if (inforssXMLRepository.isActive() == true)
      {
        this.passivateOldSelected();
        var info = this.locateFeed(url).info;
        this.selectedInfo = info;
        inforssHeadlineDisplay.setBackgroundColor(info.menuItem, false);
        info.select();
        inforssSetTimer(info, "activate", 0);
        if (info.getType() == "group")
        {
          this.mediator.updateMenuIcon(info);
        }
      }
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
  },

//-------------------------------------------------------------------------------------------------------------
  ack : function(url)
  {
    inforssTraceIn(this);
    try
    {
      var info = this.locateFeed(url).info;
	  info.setAcknowledgeDate(new Date());
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
  },

//-------------------------------------------------------------------------------------------------------------
  setPopup : function(url, flag)
  {
    inforssTraceIn(this);
    try
    {
      var info = this.locateFeed(url).info;
	  info.setPopup(flag);
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
  },

//-------------------------------------------------------------------------------------------------------------
  openTab : function(url)
  {
    inforssTraceIn(this);
    try
    {
      this.mediator.openTab(url);
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
  },

//-------------------------------------------------------------------------------------------------------------
  deleteAllRss : function()
  {
    inforssTraceIn(this);
    try
    {
      var urls = new Array();
      for (var i = 0; i < this.infoList.length; i++)
      {
        urls.push(this.infoList[i].getUrl());
      }
      for (var i = 0; i < urls.length; i++)
      {
        this.deleteRss(urls[i]);
      }
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
  },

//-------------------------------------------------------------------------------------------------------------
  deleteRss : function(url)
  {
    inforssTraceIn(this);
    try
    {
      var deletedInfo = this.locateFeed(url);
      this.infoList.splice(deletedInfo.index,1);
      if (this.infoList != null)
      {
        for (var i = 0; i < this.infoList.length; i++)
        {
          this.infoList[i].removeRss(url);
        }
      }
      var selectedInfo = this.getSelectedInfo(true);
      var deleteSelected = (selectedInfo.getUrl() == url);
      deletedInfo.info.remove();
      if (selectedInfo != null)
      {
        if (deleteSelected == true)
        {
          this.selectedInfo = null;
          if (this.infoList.length > 0)
          {
            this.mediator.setSelected(this.infoList[0].getUrl());
          }
          else
          {
            this.mediator.resetHeadlines();
          }
        }
      }
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
  },

//-------------------------------------------------------------------------------------------------------------
  getActiveFeed : function()
  {
    inforssTraceIn(this);
    try
    {
      var list = new Array();
      for (var i=0; i < this.infoList.length; i++)
      {
        if (this.infoList[i].isActiveFeed() == true)
        {
          list.push(this.infoList[i]);
        }
      }
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
    inforssTraceOut(this);
    return list;
  },

//-------------------------------------------------------------------------------------------------------------
  publishFeed : function(feed)
  {
    this.mediator.publishFeed(feed);
  },

//-------------------------------------------------------------------------------------------------------------
  unpublishFeed : function(feed)
  {
    this.mediator.unpublishFeed(feed);
  },

//-------------------------------------------------------------------------------------------------------------
  updateMenuIcon : function(feed)
  {
    this.mediator.updateMenuIcon(feed);
  },

//-------------------------------------------------------------------------------------------------------------
  clearEmptyFeedMarker : function()
  {
    this.emptyFeedMarker = null;
  },

//-------------------------------------------------------------------------------------------------------------
  getCycleGroup : function()
  {
    return this.cycleGroup;
  },

//-------------------------------------------------------------------------------------------------------------
  goHome : function()
  {
    var selectedInfo = this.getSelectedInfo(false);
    if ((selectedInfo != null) && (selectedInfo.getType() != "group"))
    {
      this.mediator.openTab(selectedInfo.getLinkAddress());
    }
  },

//-------------------------------------------------------------------------------------------------------------
  getNextGroupOrFeed1 : function(info, direction)
  {
	  gInforssMediator.feedManager.getNextGroupOrFeed(info, direction);
  },

//-------------------------------------------------------------------------------------------------------------
  getNextGroupOrFeed : function(info, direction)
  {
//dump("inforssFeedManager::getNextGroupOrFeed" + "   " + new Date() + "\n");
//dump("Direction=" + direction + "\n");
//dump("info.getType()=" + info.getType() + "\n");

    try
    {
      if (gInforssMediator.isActiveTooltip() == true)
      {
//dump("inforssFeedManager::getNextGroupOrFeed : cycle delayed\n");
    	  window.setTimeout(gInforssMediator.feedManager.getNextGroupOrFeed1, 1000, info, direction);
    	  return;
      }

//dump("inforssFeedManager::getNextGroupOrFeed : cycle nodelayed\n");
//alert(this);
      var find = false;
      var findNext = false;
      var i = 0;
      var count = (inforssXMLRepository.getNextFeed() == "next")? 1 : Math.round(Math.random()*10) + 1;
      
      var informationList = null;
      if (this.cycleGroup != null)
      {
        informationList = this.cycleGroup.infoList;
        if (informationList == null)
        {
          informationList = this.infoList;
        }
      }
      else
      {
        informationList = this.infoList;
      }

//dump("informationList.length=" + informationList.length + "\n");
      if (direction == 999)
      {
        if (this.emptyFeedMarker == null)
        {
//dump("je set " + info.getUrl() + "\n");

          this.emptyFeedMarker = info.getUrl();
        }
        else
        {
//dump("test de " + info.getUrl() + "\n");
          if (this.emptyFeedMarker == info.getUrl())
          {
            findNext = true;
            this.emptyFeedMarker = null;
            info.select();
//dump("on a fait un tour\n");
          }
        }
        direction = (this.direction == null)? 1 : this.direction;
        var selectedInfo = this.getSelectedInfo(false);
        if ((selectedInfo != null) && (selectedInfo.getType() == "group") &&
            (inforssXMLRepository.isCycling() == true) &&
            (inforssXMLRepository.isCycleWithinGroup() == false) && 
            (selectedInfo.isPlayList() == false))
        {
          findNext = true;
        }
      }
      else
      {
		this.direction = direction;
	  }

      while ((i < informationList.length) && (findNext == false))
      {
        if (find == false)
        {
          if ((informationList[i].getUrl() == info.getUrl()) && (informationList[i].getType() == info.getType()))
          {
            find = true;
            i += direction;
            if (i == informationList.length)
            {
              i = 0;
            }
            else
            {
              if (i == -1)
              {
                i = informationList.length - 1;
              }
            }
          }
          else
          {
            i++;
          }
        }
        else
        {
          if (((info.getType() == "group") && (informationList[i].getType() == "group") && (informationList[i].getFeedActivity() == true)) ||
              ((info.getType() != "group") && (informationList[i].getType() != "group") && (informationList[i].getFeedActivity() == true)))
          {
            count--;
            if (count == 0)
            {
              findNext = true;
              if ((this.emptyFeedMarker == null) || (this.emptyFeedMarker != informationList[i].getUrl()))
              {
//dump("info.getType()=" + info.getType() + "\n");
//dump("indexForPlayList =" + i + "\n");
                if (this.cycleGroup != null)
                {
                  this.cycleGroup.indexForPlayList = i;
                }
                this.setSelected(informationList[i].getUrl());
//dump("j'essaye " + informationList[i].getUrl() + "\n");
              }
              else
              {
//dump("on a fait le tour je m'arrete et j'attent le cycle suivant\n");
                this.emptyFeedMarker = null;
                info.select();
              }
            }
            else
            {
              i += direction;
              if (i == informationList.length)
              {
                i = 0;
              }
              else
              {
                if (i == -1)
                {
                  i = informationList.length - 1;
                }
              }
            }
          }
          else
          {
            i += direction;
            if (i == informationList.length)
            {
              i = 0;
            }
            else
            {
              if (i == -1)
              {
                i = informationList.length - 1;
              }
            }
          }
        }
      }
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
//dump("fin getNextGroupOrFeed\n");
  },

//-------------------------------------------------------------------------------------------------------------
  createNewRDFEntry : function(url, title, receivedDate, feedUrl)
  {
    try
    {
      this.rdfRepository.createNewRDFEntry(url, title, receivedDate, feedUrl);
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
  },

//-------------------------------------------------------------------------------------------------------------
  exists : function(url, title, checkHistory, feedUrl)
  {
    return this.rdfRepository.exists(url, title, checkHistory, feedUrl);
  },

//-------------------------------------------------------------------------------------------------------------
  getAttribute : function(url, title, attribute)
  {
    return this.rdfRepository.getAttribute(url, title, attribute);
  },

//-------------------------------------------------------------------------------------------------------------
  setAttribute : function(url, title, attribute, value)
  {
    return this.rdfRepository.setAttribute(url, title, attribute, value);
  },

//-------------------------------------------------------------------------------------------------------------
  setCycleGroup : function(group)
  {
    this.cycleGroup = group;
  },

//-------------------------------------------------------------------------------------------------------------
  newRDF : function()
  {
    this.rdfRepository.init();
  },

//-------------------------------------------------------------------------------------------------------------
  purgeRdf : function()
  {
    this.rdfRepository.purged = false;
    this.rdfRepository.purge();
  },

//-------------------------------------------------------------------------------------------------------------
  clearRdf : function()
  {
    this.rdfRepository.clearRdf();
  },

//-------------------------------------------------------------------------------------------------------------
  manualRefresh : function()
  {
    inforssTraceIn(this);
    try
    {
      var selectedInfo = this.getSelectedInfo(false);
      if (selectedInfo != null)
      {
		selectedInfo.manualRefresh();
	  }
    }
    catch(e)
    {
      inforssDebug(e, this);
    }
  },

}