; Script generated with the Venis Install Wizard & modified by crypton

; Define your application name
!define APPNAME "I2P-BT"
!define VERSION "0.1.8"
!define APPNAMEANDVERSION "${APPNAME} ${VERSION}"

; Main Install settings
Name "${APPNAMEANDVERSION}"
InstallDir "$PROGRAMFILES\I2P-BT"
InstallDirRegKey HKLM "Software\${APPNAME}" ""
OutFile "I2P-BT_${VERSION}_win32_setup.exe"
BrandingText "${APPNAMEANDVERSION}"
; Use compression
SetCompressor LZMA

; Modern interface settings
!include "MUI.nsh"

!define MUI_ABORTWARNING
!define MUI_COMPONENTSPAGE_SMALLDESC
!define MUI_FINISHPAGE_RUN "$INSTDIR\btdownloadwx.exe"

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

; Set languages (first is default language)
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_RESERVEFILE_LANGDLL

LangString TEXT_FLocations_TITLE ${LANG_ENGLISH} "Choose Default Save Locations"
LangString TEXT_FLocations_SUBTITLE ${LANG_ENGLISH} "Choose the folders to save your downloads and torrents to."



Section "I2P-BT Core" Section1

  ; Set Section properties
  SetOverwrite on

  ; Clears previous error logs
  Delete "$INSTDIR\*.log"
	
  ; Set Section Files and Shortcuts
  SetOutPath "$INSTDIR\"
  File /r "dist\*"
	
SectionEnd

Section "File Association" section2
  ; Delete any existing keys
  DeleteRegKey HKCR "Applications\btdownloadwx.exe"


  ; Write the file association
  WriteRegStr HKCR .torrent "" bittorrent
  WriteRegStr HKCR .torrent "Content Type" application/x-bittorrent
  WriteRegStr HKCR "MIME\Database\Content Type\application/x-bittorrent" Extension .torrent
  WriteRegStr HKCR bittorrent "" "TORRENT File"
  WriteRegBin HKCR bittorrent EditFlags 00000100
  WriteRegStr HKCR "bittorrent\shell" "" open
  WriteRegStr HKCR "bittorrent\shell\open\command" "" `"$INSTDIR\btdownloadwx.exe" "%1"`
SectionEnd

Section "Start Menu Shortcuts" section3

  SetOutPath "$INSTDIR"
  CreateDirectory "$SMPROGRAMS\${APPNAME}"
  CreateShortCut "$SMPROGRAMS\${APPNAME}\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\${APPNAME}\${APPNAME}.lnk" "$INSTDIR\btdownloadwx.exe" "" "$INSTDIR\btdownloadwx.exe" 0

SectionEnd

Section "Desktop Shortcuts" section4

  CreateShortCut "$DESKTOP\${APPNAME}.lnk" "$INSTDIR\btdownloadgwx.exe" "" "$INSTDIR\btdownloadwx.exe" 0
  
SectionEnd

Section -FinishSection

  WriteRegStr HKLM "Software\${APPNAME}" "" "$INSTDIR"
  WriteRegStr HKLM "Software\${APPNAME}" "Version" "${VERSION}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "DisplayName" "${APPNAME}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "UninstallString" "$INSTDIR\uninstall.exe"
  WriteUninstaller "$INSTDIR\uninstall.exe"

SectionEnd

; Modern install component descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${Section1} "I2P-BT program files"
!insertmacro MUI_DESCRIPTION_TEXT ${Section2} "Associate I2P-BT with .torrent file extension"
!insertmacro MUI_DESCRIPTION_TEXT ${Section3} "Create I2P-BT Start Menu shortcuts"
!insertmacro MUI_DESCRIPTION_TEXT ${Section4} "Create I2P-BT Desktop shortcut"	
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;Uninstall section
Section "Uninstall"
  
  ; Remove file association registry keys
  DeleteRegKey HKCR .torrent
  DeleteRegKey HKCR "MIME\Database\Content Type\application/x-bittorrent"
  DeleteRegKey HKCR bittorrent
	
  ; Remove program/uninstall regsitry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}"
  DeleteRegKey HKLM SOFTWARE\${APPNAME}

  ; Remove files and uninstaller
  Delete $INSTDIR\btdownloadgui.exe
  Delete $INSTDIR\w9xpopen.exe
  Delete $INSTDIR\*.pyd
  Delete $INSTDIR\*.dll
  Delete $INSTDIR\*.dat
  Delete $INSTDIR\*.txt
  Delete $INSTDIR\*.ini
  Delete $INSTDIR\*.log
  Delete $INSTDIR\*.ben	
  Delete $INSTDIR\*.ico



  RMDir /r "$INSTDIR\locale"

  Delete $INSTDIR\uninstall.exe

  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\${APPNAME}\*.*"

  ; Remove desktop icon
  Delete "$DESKTOP\${APPNAME}.lnk"

  ; Remove directories used
  RMDir "$SMPROGRAMS\${APPNAME}"
  RMDir "$INSTDIR"

SectionEnd



Function .onInit



  ;This was written by Vytautas - http://nsis.sourceforge.net/archive/nsisweb.php?page=453
  System::Call 'kernel32::CreateMutexA(i 0, i 0, t "I2P-BT") i .r1 ?e' 
  Pop $R0 
  StrCmp $R0 0 +3 
    MessageBox MB_OK "The ${APPNAME} installer is already running." 
    Abort 

FunctionEnd




; eof