/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.web;

import i2p.bote.I2PBote;
import i2p.bote.email.Email;
import i2p.bote.email.RecipientType;
import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import net.i2p.util.Log;

public class SendEmailTag
extends SimpleTagSupport {
    private Log log = new Log(SendEmailTag.class);
    private String senderAddress;
    private String recipientAddress;
    private String subject;
    private String message;

    public void doTag() {
        String statusMessage;
        PageContext pageContext = (PageContext)this.getJspContext();
        JspWriter out = pageContext.getOut();
        Email email = new Email();
        email.setSender(this.senderAddress);
        email.addRecipient(RecipientType.TO, this.recipientAddress);
        email.setSubject(this.subject);
        email.setContent(this.message);
        try {
            I2PBote.getInstance().sendEmail(email);
            statusMessage = "The email has been sent.";
        }
        catch (Exception e) {
            statusMessage = "Error sending email: " + e.getLocalizedMessage();
            this.log.error("Error sending email", (Throwable)e);
        }
        try {
            out.println(statusMessage);
        }
        catch (IOException e) {
            this.log.error("Can't write output to HTML page", (Throwable)e);
        }
    }

    public void setSender(String sender) {
        this.senderAddress = sender;
    }

    public String getSender() {
        return this.senderAddress;
    }

    public void setRecipient(String recipient) {
        this.recipientAddress = recipient;
    }

    public String getRecipient() {
        return this.recipientAddress;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }
}

