/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.web;

import i2p.bote.I2PBote;
import i2p.bote.network.BannedPeer;
import i2p.bote.network.DhtPeer;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import net.i2p.util.Log;

public class PeerInfoTag
extends SimpleTagSupport {
    private Log log = new Log(PeerInfoTag.class);

    public void doTag() {
        PageContext pageContext = (PageContext)this.getJspContext();
        JspWriter out = pageContext.getOut();
        try {
            Collection dhtPeers = I2PBote.getInstance().getDhtPeers();
            out.println("<strong>K-Peers: " + dhtPeers.size() + "</strong>");
            if (dhtPeers.size() > 0) {
                out.println("<table>");
                out.println("<tr>");
                out.println("<th>Peer</th>");
                out.println("<th>Destination Hash</th>");
                out.println("<th>Active Since</th>");
                out.println("<th>Stale Ctr</th>");
                out.println("</tr>");
                int peerIndex = 1;
                for (DhtPeer peer : dhtPeers) {
                    out.println("<tr>");
                    out.println("<td>" + peerIndex++ + "</td>");
                    out.println("<td>" + peer.getDestination().calculateHash().toBase64() + "</td>");
                    out.println("<td>" + new Date(peer.getActiveSince()) + "</td>");
                    out.println("<td>" + peer.getStaleCounter() + "</td>");
                    out.println("</tr>");
                }
                out.println("</table>");
            }
            out.println("<p/><br/>");
            Collection bannedPeers = I2PBote.getInstance().getBannedPeers();
            out.println("<strong>Banned Peers: " + bannedPeers.size() + "</strong>");
            if (bannedPeers.size() > 0) {
                out.println("<table>");
                out.println("<tr>");
                out.println("<th>Peer</th>");
                out.println("<th>Destination Hash</th>");
                out.println("<th>Ban Reason</th>");
                out.println("</tr>");
                int peerIndex = 1;
                for (BannedPeer peer : bannedPeers) {
                    out.println("<tr>");
                    out.println("<td>" + peerIndex++ + "</td>");
                    out.println("<td>" + peer.getDestination().calculateHash().toBase64() + "</td>");
                    out.println("<td>" + (peer.getBanReason() == null ? "" : peer.getBanReason()) + "</td>");
                    out.println("</tr>");
                }
                out.println("</table>");
            }
        }
        catch (IOException e) {
            this.log.error("Can't write output to HTML page", (Throwable)e);
        }
    }
}

