/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.service;

import i2p.bote.I2PBote;
import i2p.bote.network.NetworkStatus;
import java.util.concurrent.TimeUnit;
import net.i2p.util.I2PAppThread;

public class AutoMailCheckTask
extends I2PAppThread {
    private long interval;

    public AutoMailCheckTask(int interval) {
        this.interval = TimeUnit.MINUTES.toMillis(interval);
    }

    public void run() {
        while (true) {
            long timeSinceLastCheck = System.currentTimeMillis() - I2PBote.getInstance().getLastMailCheckTime();
            try {
                if (I2PBote.getInstance().getNetworkStatus() != NetworkStatus.CONNECTED) {
                    TimeUnit.MINUTES.sleep(1L);
                    continue;
                }
                if (timeSinceLastCheck < this.interval) {
                    Thread.sleep(this.interval - timeSinceLastCheck);
                    continue;
                }
                I2PBote.getInstance().checkForMail();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void shutDown() {
        this.interrupt();
    }
}

