/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet.dht;

import i2p.bote.packet.DataPacket;
import i2p.bote.packet.I2PBotePacket;
import i2p.bote.packet.MalformedDataPacketException;
import java.io.File;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public abstract class DhtStorablePacket
extends DataPacket {
    private static Log log = new Log(DhtStorablePacket.class);

    public DhtStorablePacket() {
    }

    public DhtStorablePacket(byte[] data) {
        super(data);
    }

    public abstract Hash getDhtKey();

    public static DhtStorablePacket createPacket(byte[] data) throws MalformedDataPacketException {
        DataPacket packet = DataPacket.createPacket((byte[])data);
        if (packet instanceof DhtStorablePacket) {
            return (DhtStorablePacket)packet;
        }
        log.error("Packet is not a DhtStorablePacket: " + packet);
        return null;
    }

    public static Class<? extends DhtStorablePacket> decodePacketTypeCode(char packetTypeCode) {
        Class packetType = I2PBotePacket.decodePacketTypeCode((char)packetTypeCode);
        if (packetType != null && DhtStorablePacket.class.isAssignableFrom(packetType)) {
            return packetType.asSubclass(DhtStorablePacket.class);
        }
        log.debug("Invalid type code for DhtStorablePacket: <" + packetTypeCode + ">");
        return null;
    }

    public static DhtStorablePacket createPacket(File file) throws MalformedDataPacketException {
        if (file == null || !file.exists()) {
            return null;
        }
        DataPacket dataPacket = DataPacket.createPacket((File)file);
        if (dataPacket instanceof DhtStorablePacket) {
            return (DhtStorablePacket)dataPacket;
        }
        log.warn("Expected: DhtStorablePacket, got: " + dataPacket.getClass().getSimpleName());
        return null;
    }
}

