/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.packet.DataPacket;
import i2p.bote.packet.TypeCode;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.Log;

@TypeCode(value=76)
public class PeerList
extends DataPacket {
    private Log log = new Log(PeerList.class);
    private Collection<Destination> peers;

    public PeerList(Collection<Destination> peers) {
        this.peers = peers;
    }

    public PeerList(byte[] data) throws DataFormatException {
        super(data);
        ByteBuffer buffer = ByteBuffer.wrap(data, 2, data.length - 2);
        int numPeers = buffer.getShort();
        this.peers = new ArrayList();
        for (int i = 0; i < numPeers; ++i) {
            byte[] peerData = new byte[388];
            buffer.get(peerData, 0, 384);
            Destination peer = new Destination();
            peer.readBytes(peerData, 0);
            this.peers.add(peer);
        }
        if (buffer.hasRemaining()) {
            this.log.debug("Peer List has " + buffer.remaining() + " extra bytes.");
        }
    }

    public Collection<Destination> getPeers() {
        return this.peers;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(arrayOutputStream);
        try {
            this.writeHeader((OutputStream)dataStream);
            dataStream.writeShort(this.peers.size());
            for (Destination peer : this.peers) {
                dataStream.write(peer.toByteArray(), 0, 384);
            }
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return arrayOutputStream.toByteArray();
    }
}

