/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.packet;

import i2p.bote.UniqueId;
import i2p.bote.email.EmailDestination;
import i2p.bote.packet.EncryptedEmailPacket;
import i2p.bote.packet.TypeCode;
import i2p.bote.packet.dht.DhtStorablePacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.util.Log;

@TypeCode(value=73)
public class IndexPacket
extends DhtStorablePacket {
    private Log log = new Log(IndexPacket.class);
    private Map<Hash, UniqueId> entries;
    private Hash destinationHash;

    public IndexPacket(Collection<EncryptedEmailPacket> emailPackets, EmailDestination emailDestination) {
        this.entries = new ConcurrentHashMap();
        for (EncryptedEmailPacket emailPacket : emailPackets) {
            this.entries.put(emailPacket.getDhtKey(), emailPacket.getPlaintextDeletionKey());
        }
        this.destinationHash = emailDestination.getHash();
    }

    public IndexPacket(Collection<IndexPacket> indexPackets) {
        if (indexPackets == null || indexPackets.isEmpty()) {
            throw new IllegalArgumentException("This method must be invoked with at least one index packet.");
        }
        this.destinationHash = indexPackets.iterator().next().getDhtKey();
        this.entries = new ConcurrentHashMap();
        for (IndexPacket packet : indexPackets) {
            this.entries.putAll(packet.getEntries());
        }
    }

    public IndexPacket(IndexPacket ... indexPackets) {
        this(Arrays.asList(indexPackets));
    }

    public IndexPacket(byte[] data) {
        super(data);
        ByteBuffer buffer = ByteBuffer.wrap(data, 2, data.length - 2);
        this.destinationHash = this.readHash(buffer);
        int numKeys = buffer.get();
        this.entries = new ConcurrentHashMap();
        for (int i = 0; i < numKeys; ++i) {
            Hash dhtKey = this.readHash(buffer);
            UniqueId delKey = new UniqueId(buffer);
            this.entries.put(dhtKey, delKey);
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.writeHeader((OutputStream)outputStream);
            this.destinationHash.writeBytes((OutputStream)outputStream);
            outputStream.write((byte)this.entries.size());
            for (Map.Entry entry : this.entries.entrySet()) {
                ((Hash)entry.getKey()).writeBytes((OutputStream)outputStream);
                ((UniqueId)entry.getValue()).writeTo((OutputStream)outputStream);
            }
        }
        catch (DataFormatException e) {
            this.log.error("Invalid format for email destination.", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return outputStream.toByteArray();
    }

    public UniqueId getDeletionKey(Hash dhtKey) {
        return (UniqueId)this.entries.get(dhtKey);
    }

    public Collection<Hash> getDhtKeys() {
        return this.entries.keySet();
    }

    public void put(Hash dhtKey, UniqueId deletionKey) {
        this.entries.put(dhtKey, deletionKey);
    }

    public void remove(Hash dhtKey) {
        this.entries.remove(dhtKey);
    }

    public boolean contains(Hash dhtKey) {
        return this.entries.containsKey(dhtKey);
    }

    public Map<Hash, UniqueId> getEntries() {
        return this.entries;
    }

    public Hash getDhtKey() {
        return this.destinationHash;
    }
}

