/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.network.DhtPeer;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public class KademliaPeer
extends Destination
implements DhtPeer {
    private Log log = new Log(KademliaPeer.class);
    private Destination destination;
    private Hash destinationHash;
    private long lastPingSent;
    private long lastReception;
    private long activeSince;
    private AtomicInteger consecutiveTimeouts;

    public KademliaPeer(Destination destination, long lastReception) {
        this.setCertificate(destination.getCertificate());
        this.setSigningPublicKey(destination.getSigningPublicKey());
        this.setPublicKey(destination.getPublicKey());
        this.destination = destination;
        this.destinationHash = destination.calculateHash();
        if (this.destinationHash == null) {
            this.log.error("calculateHash() returned null!");
        }
        this.lastReception = lastReception;
        this.lastPingSent = 0L;
        this.activeSince = lastReception;
        this.consecutiveTimeouts = new AtomicInteger(0);
    }

    public KademliaPeer(Destination destination) {
        this(destination, System.currentTimeMillis());
    }

    public Destination getDestination() {
        return this.destination;
    }

    public Hash getDestinationHash() {
        return this.destinationHash;
    }

    public boolean isDead() {
        return this.consecutiveTimeouts.get() >= 3;
    }

    public int getStaleCounter() {
        return this.consecutiveTimeouts.get();
    }

    public void incrementStaleCounter() {
        this.consecutiveTimeouts.incrementAndGet();
    }

    public void resetStaleCounter() {
        this.consecutiveTimeouts.set(0);
    }

    public long getLastPingSent() {
        return this.lastPingSent;
    }

    public void setLastReception(long time) {
        this.lastReception = time;
    }

    public long getLastReception() {
        return this.lastReception;
    }

    public long getActiveSince() {
        return this.activeSince;
    }
}

