/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.network.kademlia.AbstractBucket;
import i2p.bote.network.kademlia.KademliaPeer;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

class KBucket
extends AbstractBucket {
    private static final int REPLACEMENT_CACHE_MAX_SIZE = 2;
    private Log log = new Log(KBucket.class);
    private BigInteger startId;
    private BigInteger endId;
    private Set<KademliaPeer> replacementCache;
    private int depth;

    KBucket(BigInteger startId, BigInteger endId, int capacity, int depth) {
        super(capacity);
        this.startId = startId;
        this.endId = endId;
        this.replacementCache = new ConcurrentHashSet();
        this.depth = depth;
    }

    BigInteger getStartId() {
        return this.startId;
    }

    BigInteger getEndId() {
        return this.endId;
    }

    void add(Destination destination) {
        KademliaPeer peer;
        if (this.isFull()) {
            this.log.error("Error: adding a node to a full k-bucket. Bucket needs to be split first. Size=" + this.size() + ", capacity=" + this.capacity);
        }
        if ((peer = this.getPeer(destination)) == null) {
            this.peers.add(peer);
        }
    }

    synchronized KBucket addOrSplit(Destination destination) {
        if (!this.rangeContains(destination)) {
            this.log.error("Attempt to add a node whose hash is outside the bucket's range! Bucket start=" + this.startId + " Bucket end=" + this.endId + " peer hash=" + new BigInteger(destination.calculateHash().getData()));
        }
        KademliaPeer peer = this.getPeer(destination);
        if (this.isFull() && peer == null) {
            if (this.canSplit(destination)) {
                KBucket newBucket = this.split(destination.calculateHash());
                if (this.rangeContains(destination)) {
                    this.add(destination);
                } else if (newBucket.rangeContains(destination)) {
                    newBucket.add(destination);
                } else {
                    this.log.error("After splitting a bucket, node is outside of both buckets' ranges.");
                }
                return newBucket;
            }
            this.addOrUpdateReplacement(new KademliaPeer(destination));
            return null;
        }
        if (peer == null) {
            this.peers.add(new KademliaPeer(destination, System.currentTimeMillis()));
        } else {
            peer.setLastReception(System.currentTimeMillis());
        }
        return null;
    }

    private void addOrUpdateReplacement(KademliaPeer peer) {
        this.replacementCache.add(peer);
        while (this.replacementCache.size() > 2) {
            this.removeOldest((Collection)this.replacementCache);
        }
    }

    private void removeOldest(Collection<KademliaPeer> peers) {
        KademliaPeer oldestPeer = null;
        for (KademliaPeer peer : peers) {
            if (oldestPeer != null && peer.getLastReception() >= oldestPeer.getLastReception()) continue;
            oldestPeer = peer;
        }
    }

    private boolean canSplit(Destination peer) {
        return this.depth % 1 != 0 || this.rangeContains(peer);
    }

    private boolean rangeContains(Destination peer) {
        BigInteger peerHash = new BigInteger(peer.calculateHash().getData());
        return this.startId.compareTo(peerHash) <= 0 || this.endId.compareTo(peerHash) > 0;
    }

    KBucket split(Hash hash) {
        return this.split(new BigInteger(hash.toBase64()));
    }

    KBucket split(BigInteger pivot) {
        ++this.depth;
        KBucket newBucket = new KBucket(this.startId, pivot.subtract(BigInteger.ONE), this.capacity, this.depth);
        this.startId = pivot;
        for (KademliaPeer peer : this.peers) {
            BigInteger nodeId = new BigInteger(peer.getDestinationHash().getData());
            if (nodeId.compareTo(pivot) < 0) continue;
            newBucket.add((Destination)peer);
            this.remove(peer);
        }
        return newBucket;
    }
}

