/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.network.I2PPacketDispatcher;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.network.PacketListener;
import i2p.bote.network.kademlia.BucketManager;
import i2p.bote.network.kademlia.ClosestNodesLookupTask;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.dht.FindClosePeersPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class ClosestNodesLookupTask
implements Runnable {
    private static final int REQUEST_TIMEOUT = 30000;
    private static final int CLOSEST_NODES_LOOKUP_TIMEOUT = 120000;
    private Log log = new Log(ClosestNodesLookupTask.class);
    private Hash key;
    private I2PPacketDispatcher i2pReceiver;
    private BucketManager bucketManager;
    private Random randomNumberGenerator;
    private I2PSendQueue sendQueue;
    private Set<Destination> responses;
    private Set<Destination> notQueriedYet;
    private Map<Destination, FindClosePeersPacket> pendingRequests;
    private long startTime;

    public ClosestNodesLookupTask(Hash key, I2PSendQueue sendQueue, I2PPacketDispatcher i2pReceiver, BucketManager bucketManager) {
        this.key = key;
        this.sendQueue = sendQueue;
        this.i2pReceiver = i2pReceiver;
        this.bucketManager = bucketManager;
        this.randomNumberGenerator = new Random(this.getTime());
        this.responses = Collections.synchronizedSet(new TreeSet(new HashDistanceComparator(this, key)));
        this.notQueriedYet = new ConcurrentHashSet();
        this.pendingRequests = new ConcurrentHashMap();
    }

    @Override
    public void run() {
        this.log.debug("Looking up nodes closest to " + this.key);
        IncomingPacketHandler packetListener = new IncomingPacketHandler(this, null);
        this.i2pReceiver.addPacketListener((PacketListener)packetListener);
        this.notQueriedYet.addAll(this.bucketManager.getClosestPeers(this.key, 3));
        this.startTime = this.getTime();
        while (true) {
            if (this.pendingRequests.size() < 3 && !this.notQueriedYet.isEmpty()) {
                Destination peer = this.selectRandom((Collection)this.notQueriedYet);
                this.notQueriedYet.remove(peer);
                FindClosePeersPacket packet = new FindClosePeersPacket(this.key);
                this.pendingRequests.put(peer, packet);
                this.sendQueue.send((CommunicationPacket)packet, peer);
                continue;
            }
            for (Map.Entry request : this.pendingRequests.entrySet()) {
                if (!this.hasTimedOut((CommunicationPacket)request.getValue(), 30000L)) continue;
                Destination peer = (Destination)request.getKey();
                this.bucketManager.incrementStaleCounter(peer);
                this.pendingRequests.remove(peer);
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted while doing a closest nodes lookup.", (Throwable)e);
            }
            if (this.isDone()) break;
        }
        this.log.debug(this.responses.size() + " nodes found (may include local node).");
        for (Destination node : this.responses) {
            this.log.debug("  Node: " + node.calculateHash());
        }
        this.i2pReceiver.removePacketListener((PacketListener)packetListener);
    }

    private boolean isDone() {
        if (this.pendingRequests.isEmpty() && this.notQueriedYet.isEmpty()) {
            return true;
        }
        if (this.responses.size() >= 3) {
            return true;
        }
        if (this.hasTimedOut(this.startTime, 120000L)) {
            this.log.error("Lookup for closest nodes timed out.");
            return true;
        }
        return false;
    }

    private Destination selectRandom(Collection<Destination> collection) {
        Destination[] array = new Destination[collection.size()];
        int index = this.randomNumberGenerator.nextInt(array.length);
        return collection.toArray(array)[index];
    }

    private long getTime() {
        return System.currentTimeMillis();
    }

    private boolean hasTimedOut(long startTime, long timeout) {
        return this.getTime() > startTime + timeout;
    }

    private boolean hasTimedOut(CommunicationPacket request, long timeout) {
        long sentTime = request.getSentTime();
        return sentTime > 0L && this.hasTimedOut(sentTime, timeout);
    }

    public List<Destination> getResults() {
        List<Object> resultsList = new ArrayList<Destination>();
        for (Destination destination : this.responses) {
            resultsList.add(destination);
        }
        Collections.sort(resultsList, new HashDistanceComparator(this, this.key));
        if (resultsList.size() > 3) {
            resultsList = resultsList.subList(0, 3);
        }
        return resultsList;
    }

    static /* synthetic */ Map access$100(ClosestNodesLookupTask x0) {
        return x0.pendingRequests;
    }

    static /* synthetic */ Set access$200(ClosestNodesLookupTask x0) {
        return x0.responses;
    }

    static /* synthetic */ Log access$300(ClosestNodesLookupTask x0) {
        return x0.log;
    }

    static /* synthetic */ Set access$400(ClosestNodesLookupTask x0) {
        return x0.notQueriedYet;
    }
}

