/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.network.BanList;
import i2p.bote.network.PacketListener;
import i2p.bote.network.kademlia.AbstractBucket;
import i2p.bote.network.kademlia.BucketManager;
import i2p.bote.network.kademlia.KBucket;
import i2p.bote.network.kademlia.KademliaPeer;
import i2p.bote.network.kademlia.KademliaUtil;
import i2p.bote.network.kademlia.SBucket;
import i2p.bote.packet.CommunicationPacket;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class BucketManager
implements PacketListener,
Iterable<KBucket> {
    private Log log = new Log(BucketManager.class);
    private List<KBucket> kBuckets;
    private SBucket sBucket;
    private Hash localDestinationHash;

    public BucketManager(Hash localDestinationHash) {
        this.localDestinationHash = localDestinationHash;
        this.kBuckets = Collections.synchronizedList(new ArrayList());
        this.kBuckets.add(new KBucket(AbstractBucket.MIN_HASH_VALUE, AbstractBucket.MAX_HASH_VALUE, 2, 0));
        this.sBucket = new SBucket(3);
    }

    public void addAll(Collection<KademliaPeer> peers) {
        for (KademliaPeer node : peers) {
            this.addOrUpdate((Destination)node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdate(Destination destination) {
        Hash destHash = destination.calculateHash();
        if (this.localDestinationHash.equals((Object)destHash)) {
            this.log.debug("Not adding local destination to bucket.");
            return;
        }
        this.log.debug("Adding/updating peer: Hash = " + destHash);
        BucketManager bucketManager = this;
        synchronized (bucketManager) {
            if (!this.sBucket.isFull() || this.sBucket.contains(destination)) {
                this.sBucket.addOrUpdate(destination);
                this.getKBucket(destHash).remove(destination);
            } else if (this.isCloserSibling(destination)) {
                Destination ejectedPeer = this.sBucket.getMostDistantPeer(this.localDestinationHash);
                this.addToKBucket(ejectedPeer);
                this.sBucket.remove(ejectedPeer);
                this.sBucket.addOrUpdate(destination);
                this.getKBucket(destHash).remove(destination);
            } else {
                this.addToKBucket(destination);
            }
        }
        this.logBucketStats();
    }

    private void addToKBucket(Destination destination) {
        KBucket bucket = this.getKBucket(destination);
        KBucket newBucket = bucket.addOrSplit(destination);
        if (newBucket != null) {
            this.kBuckets.add(newBucket);
        }
    }

    public void incrementStaleCounter(Destination destination) {
        AbstractBucket bucket = this.getBucket(destination);
        if (bucket != null) {
            KademliaPeer peer = bucket.getPeer(destination);
            if (peer != null) {
                peer.incrementStaleCounter();
                if (peer.isDead()) {
                    bucket.remove(peer);
                }
            }
        } else {
            this.log.debug("Can't increment stale counter because peer not found in buckets: " + destination.calculateHash());
        }
    }

    private void logBucketStats() {
        int numBuckets = this.kBuckets.size();
        int numPeers = this.getAllPeers().size();
        int numSiblings = this.sBucket.size();
        this.log.debug("total #peers=" + numPeers + ", #siblings=" + numSiblings + ", #buckets=" + numBuckets + " (not counting the sibling bucket)");
    }

    private boolean isCloserSibling(Destination dest) {
        BigInteger peerDistance = KademliaUtil.getDistance((Destination)dest, (Hash)this.localDestinationHash);
        for (KademliaPeer sibling : this.sBucket) {
            BigInteger siblingDistance = KademliaUtil.getDistance((Hash)sibling.getDestinationHash(), (Hash)this.localDestinationHash);
            if (peerDistance.compareTo(siblingDistance) >= 0) continue;
            return true;
        }
        return false;
    }

    public void remove(KademliaPeer peer) {
        AbstractBucket bucket = this.getBucket((Destination)peer);
        if (bucket != null) {
            bucket.remove(peer);
        } else {
            this.log.debug("Can't remove peer because no bucket contains it: " + peer.getDestinationHash().toBase64());
        }
    }

    private int getBucketIndex(Hash key) {
        int lowEnd = 0;
        int highEnd = this.kBuckets.size();
        BigInteger keyValue = new BigInteger(key.getData());
        while (lowEnd < highEnd) {
            int centerIndex = (highEnd + lowEnd) / 2;
            if (keyValue.compareTo(((KBucket)this.kBuckets.get(centerIndex)).getStartId()) < 0) {
                highEnd = centerIndex;
                continue;
            }
            if (keyValue.compareTo(((KBucket)this.kBuckets.get(centerIndex)).getEndId()) > 0) {
                lowEnd = centerIndex;
                continue;
            }
            return centerIndex;
        }
        this.log.error("This should never happen! No k-bucket found for hash: " + key);
        return -1;
    }

    private KBucket getKBucket(Hash key) {
        return (KBucket)this.kBuckets.get(this.getBucketIndex(key));
    }

    private KBucket getKBucket(Destination destination) {
        return this.getKBucket(destination.calculateHash());
    }

    private KademliaPeer getPeer(Destination destination) {
        AbstractBucket bucket = this.getBucket(destination);
        if (bucket != null) {
            return bucket.getPeer(destination);
        }
        return null;
    }

    private AbstractBucket getBucket(Destination destination) {
        if (this.sBucket.contains(destination)) {
            return this.sBucket;
        }
        KBucket kBucket = this.getKBucket(destination.calculateHash());
        if (kBucket.contains(destination)) {
            return kBucket;
        }
        return null;
    }

    public Collection<Destination> getClosestPeers(Hash key, int count) {
        ConcurrentHashSet closestPeers = new ConcurrentHashSet();
        KademliaPeer[] allPeers = this.getAllPeersSortedByDistance(key);
        for (int i = 0; i < count && i < allPeers.length; ++i) {
            closestPeers.add(allPeers[i]);
        }
        return closestPeers;
    }

    private KademliaPeer[] getAllPeersSortedByDistance(Hash key) {
        List allPeers = this.getAllPeers();
        KademliaPeer[] peerArray = this.getAllPeers().toArray(new KademliaPeer[allPeers.size()]);
        Arrays.sort(peerArray, new PeerDistanceComparator(this, key));
        return peerArray;
    }

    public List<KademliaPeer> getAllPeers() {
        ArrayList<KademliaPeer> allPeers = new ArrayList<KademliaPeer>();
        for (KBucket bucket : this.kBuckets) {
            allPeers.addAll(bucket.getPeers());
        }
        allPeers.addAll(this.sBucket.getPeers());
        return allPeers;
    }

    public List<KademliaPeer> getSiblings() {
        ArrayList<KademliaPeer> siblingDestinations = new ArrayList<KademliaPeer>();
        for (KademliaPeer sibling : this.sBucket) {
            siblingDestinations.add(sibling);
        }
        return siblingDestinations;
    }

    public int getPeerCount() {
        int count = 0;
        for (KBucket bucket : this.kBuckets) {
            count += bucket.size();
        }
        return count += this.sBucket.size();
    }

    public void packetReceived(CommunicationPacket packet, Destination sender, long receiveTime) {
        boolean banned = false;
        KademliaPeer peer = this.getPeer(sender);
        if (peer != null) {
            if (packet.getProtocolVersion() != 2) {
                BanList.getInstance().ban((Destination)peer, "Wrong protocol version: " + packet.getProtocolVersion());
                this.remove(peer);
                banned = true;
            } else {
                BanList.getInstance().unban((Destination)peer);
            }
        }
        if (!banned) {
            this.addOrUpdate(sender);
        }
    }

    @Override
    public Iterator<KBucket> iterator() {
        return this.kBuckets.iterator();
    }
}

