/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network.kademlia;

import i2p.bote.network.kademlia.KademliaPeer;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Set;
import net.i2p.data.Destination;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

public class AbstractBucket
implements Iterable<KademliaPeer> {
    static final BigInteger MIN_HASH_VALUE = BigInteger.ONE.negate().shiftLeft(256);
    static final BigInteger MAX_HASH_VALUE = BigInteger.ONE.shiftLeft(256).subtract(BigInteger.ONE);
    private Log log = new Log(AbstractBucket.class);
    protected Set<KademliaPeer> peers = new ConcurrentHashSet();
    protected int capacity;

    public AbstractBucket(int capacity) {
        this.capacity = capacity;
    }

    boolean addOrUpdate(Destination destination) {
        KademliaPeer peer = this.getPeer(destination);
        if (peer == null) {
            this.peers.add(new KademliaPeer(destination));
            return true;
        }
        peer.resetStaleCounter();
        peer.setLastReception(System.currentTimeMillis());
        return false;
    }

    void remove(Destination destination) {
        KademliaPeer peer = this.getPeer(destination);
        if (peer != null) {
            this.remove(peer);
        }
    }

    void remove(KademliaPeer peer) {
        this.log.debug("Removing peer from bucket: " + peer.getDestinationHash());
        this.peers.remove(peer);
    }

    Set<KademliaPeer> getPeers() {
        return this.peers;
    }

    protected KademliaPeer getPeer(Destination destination) {
        for (KademliaPeer peer : this.peers) {
            if (!peer.equals((Object)destination)) continue;
            return peer;
        }
        return null;
    }

    boolean contains(Destination destination) {
        return this.getPeer(destination) != null;
    }

    boolean isFull() {
        return this.size() >= this.capacity;
    }

    int size() {
        return this.peers.size();
    }

    @Override
    public Iterator<KademliaPeer> iterator() {
        return this.peers.iterator();
    }
}

