/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network;

import i2p.bote.UniqueId;
import i2p.bote.network.PacketBatchItem;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.DataPacket;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.i2p.data.Destination;
import net.i2p.util.Log;

public class PacketBatch
implements Iterable<PacketBatchItem> {
    private final Log log = new Log(PacketBatch.class);
    private Map<UniqueId, PacketBatchItem> outgoingPackets = new ConcurrentHashMap();
    private Map<Destination, DataPacket> incomingPackets = new ConcurrentHashMap();
    private CountDownLatch sentSignal = new CountDownLatch(0);
    private CountDownLatch firstReplyReceivedSignal = new CountDownLatch(1);

    public synchronized void putPacket(CommunicationPacket packet, Destination destination) {
        this.outgoingPackets.put(packet.getPacketId(), new PacketBatchItem(packet, destination));
        this.sentSignal = new CountDownLatch((int)this.sentSignal.getCount() + 1);
    }

    public boolean contains(UniqueId packetId) {
        return this.outgoingPackets.containsKey(packetId);
    }

    public int getPacketCount() {
        return this.outgoingPackets.keySet().size();
    }

    @Override
    public Iterator<PacketBatchItem> iterator() {
        return this.outgoingPackets.values().iterator();
    }

    void addResponse(Destination peer, DataPacket packet) {
        this.incomingPackets.put(peer, packet);
        this.firstReplyReceivedSignal.countDown();
    }

    public Map<Destination, DataPacket> getResponses() {
        return this.incomingPackets;
    }

    synchronized void initializeSentSignal() {
        this.sentSignal = new CountDownLatch(this.getPacketCount());
    }

    void decrementSentLatch() {
        this.sentSignal.countDown();
    }

    public void awaitSendCompletion() throws InterruptedException {
        boolean timedOut;
        boolean bl = timedOut = !this.sentSignal.await(5L, TimeUnit.MINUTES);
        if (timedOut) {
            this.log.warn("Batch not sent within 5 minutes!");
        }
    }

    public int getUnsentPacketCount() {
        return (int)this.sentSignal.getCount();
    }

    public void awaitFirstReply(long timeout, TimeUnit timeoutUnit) throws InterruptedException {
        this.firstReplyReceivedSignal.await(timeout, timeoutUnit);
    }

    public void awaitAllResponses(long timeout, TimeUnit timeoutUnit) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        long timeoutMillis = timeoutUnit.toMillis(timeout);
        long endTime = startTime + timeoutMillis;
        this.log.debug("Waiting for responses to batch packets. Start time=" + startTime + ", end time=" + endTime);
        while (System.currentTimeMillis() <= endTime && this.incomingPackets.size() < this.outgoingPackets.size()) {
            TimeUnit.SECONDS.sleep(1L);
        }
        this.log.debug("Finished waiting. Time now: " + System.currentTimeMillis() + ", #incoming=" + this.incomingPackets.size() + ", #outgoing=" + this.outgoingPackets.size());
    }
}

