/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.network;

import i2p.bote.network.BannedPeer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Destination;

public class BanList {
    private static BanList instance;
    private Map<Destination, String> bannedPeers = new ConcurrentHashMap();

    public static synchronized BanList getInstance() {
        if (instance == null) {
            instance = new BanList();
        }
        return instance;
    }

    private BanList() {
    }

    public void ban(Destination destination, String reason) {
        this.bannedPeers.put(destination, reason);
    }

    public void unban(Destination destination) {
        this.bannedPeers.remove(destination);
    }

    public boolean isBanned(Destination destination) {
        return this.bannedPeers.containsKey(destination);
    }

    public String getBanReason(Destination destination) {
        return (String)this.bannedPeers.get(destination);
    }

    public Collection<BannedPeer> getAll() {
        ArrayList<BannedPeer> peerCollection = new ArrayList<BannedPeer>();
        for (Map.Entry entry : this.bannedPeers.entrySet()) {
            peerCollection.add(new BannedPeer((Destination)entry.getKey(), (String)entry.getValue()));
        }
        return peerCollection;
    }
}

