/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.folder;

import i2p.bote.email.Email;
import i2p.bote.folder.EmailFolder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.i2p.util.Log;

public class Outbox
extends EmailFolder {
    private static final String STATUS_FILE_EXTENSION = ".status";
    private static final Log log = new Log(Outbox.class);

    public Outbox(File storageDir) {
        super(storageDir);
    }

    public void add(Email email) throws IOException {
        super.add(email);
        String queueDate = String.valueOf(System.currentTimeMillis());
        File statusFile = this.getStatusFile(email);
        FileWriter statusFileWriter = new FileWriter(statusFile);
        statusFileWriter.write(queueDate);
        statusFileWriter.close();
    }

    private File getStatusFile(Email email) {
        return new File(this.storageDir, email.getMessageID() + STATUS_FILE_EXTENSION);
    }

    public void delete(Email email) {
        super.delete(email);
        if (!this.getStatusFile(email).delete()) {
            log.error("Cannot delete file: '" + this.getStatusFile(email) + "'");
        }
    }

    public void updateStatus(Email email, int[] relayInfo, String statusMessage) {
    }
}

