/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.folder;

import i2p.bote.UniqueId;
import i2p.bote.folder.EmailFolder;
import i2p.bote.folder.IncompleteEmailFolder;
import i2p.bote.folder.PacketFolder;
import i2p.bote.packet.DataPacket;
import i2p.bote.packet.UnencryptedEmailPacket;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import net.i2p.util.Log;

public class IncompleteEmailFolder
extends PacketFolder<UnencryptedEmailPacket> {
    private Log log = new Log(IncompleteEmailFolder.class);
    private EmailFolder inbox;

    public IncompleteEmailFolder(File storageDir, EmailFolder inbox) {
        super(storageDir);
        this.inbox = inbox;
    }

    public void add(UnencryptedEmailPacket packetToStore) {
        this.addEmailPacket(packetToStore);
    }

    public synchronized boolean addEmailPacket(UnencryptedEmailPacket packetToStore) {
        this.add((DataPacket)packetToStore, this.getFilename(packetToStore));
        File[] finishedPacketFiles = this.getAllMatchingFiles(packetToStore.getMessageId());
        if (finishedPacketFiles.length == packetToStore.getNumFragments()) {
            this.assemble(finishedPacketFiles);
            return true;
        }
        return false;
    }

    private String getFilename(UnencryptedEmailPacket packet) {
        String fragIndex = String.format("%03d", packet.getFragmentIndex());
        return packet.getMessageId() + "_" + fragIndex + ".pkt";
    }

    private void assemble(File[] packetFiles) {
        new AssembleTask(this, packetFiles, this.inbox).run();
    }

    private File[] getAllMatchingFiles(UniqueId messageId) {
        String base64Id = messageId.toBase64();
        return this.storageDir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected UnencryptedEmailPacket createFolderElement(File file) throws Exception {
        FileInputStream inputStream = new FileInputStream(file);
        return new UnencryptedEmailPacket((InputStream)inputStream);
    }

    static /* synthetic */ EmailFolder access$000(IncompleteEmailFolder x0) {
        return x0.inbox;
    }

    static /* synthetic */ Log access$100(IncompleteEmailFolder x0) {
        return x0.log;
    }
}

