/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.folder;

import i2p.bote.UniqueId;
import i2p.bote.folder.DhtPacketFolder;
import i2p.bote.network.PacketListener;
import i2p.bote.packet.CommunicationPacket;
import i2p.bote.packet.EmailPacketDeleteRequest;
import i2p.bote.packet.EncryptedEmailPacket;
import i2p.bote.packet.dht.DhtStorablePacket;
import java.io.File;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public class EmailPacketFolder
extends DhtPacketFolder<EncryptedEmailPacket>
implements PacketListener {
    private Log log = new Log(EmailPacketFolder.class);

    public EmailPacketFolder(File storageDir) {
        super(storageDir);
    }

    public void packetReceived(CommunicationPacket packet, Destination sender, long receiveTime) {
        if (packet instanceof EmailPacketDeleteRequest) {
            EmailPacketDeleteRequest delRequest = (EmailPacketDeleteRequest)packet;
            Hash dhtKey = delRequest.getDhtKey();
            DhtStorablePacket storedPacket = this.retrieve(dhtKey);
            if (storedPacket instanceof EncryptedEmailPacket) {
                UniqueId storedDeletionKey = ((EncryptedEmailPacket)storedPacket).getPlaintextDeletionKey();
                if (storedDeletionKey.equals((Object)delRequest.getDeletionKey())) {
                    this.delete(dhtKey);
                } else {
                    this.log.debug("Deletion key in EmailPacketDeleteRequest does not match. Should be: <" + storedDeletionKey + ">, is <" + delRequest.getDeletionKey() + ">");
                }
            } else {
                this.log.debug("EncryptedEmailPacket expected for DHT key <" + dhtKey + ">, found " + storedPacket.getClass().getSimpleName());
            }
        }
    }
}

