/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.folder;

import i2p.bote.email.Email;
import i2p.bote.email.MessageId;
import i2p.bote.folder.Folder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.util.Log;

public class EmailFolder
extends Folder<Email> {
    protected static final String EMAIL_FILE_EXTENSION = ".mail";
    private Log log = new Log(EmailFolder.class);

    public EmailFolder(File storageDir) {
        super(storageDir, EMAIL_FILE_EXTENSION);
    }

    public void add(Email email) throws IOException {
        File emailFile = this.getEmailFile(email);
        this.log.info("Mail folder <" + this.storageDir + ">: storing email file: <" + emailFile.getAbsolutePath() + ">");
        FileOutputStream emailOutputStream = new FileOutputStream(emailFile);
        email.writeTo((OutputStream)emailOutputStream);
        ((OutputStream)emailOutputStream).close();
    }

    public Email getEmail(String messageIdString) {
        MessageId messageId = new MessageId(messageIdString);
        File file = this.getEmailFile(messageId);
        try {
            return this.createFolderElement(file);
        }
        catch (Exception e) {
            this.log.error("Can't read email from file: <" + file.getAbsolutePath() + ">", (Throwable)e);
            return null;
        }
    }

    private File getEmailFile(Email email) {
        return this.getEmailFile(email.getMessageID(), email.isNew());
    }

    private File getEmailFile(MessageId messageId) {
        File newEmailFile = this.getEmailFile(messageId, true);
        if (newEmailFile.exists()) {
            return newEmailFile;
        }
        File oldEmailFile = this.getEmailFile(messageId, false);
        if (oldEmailFile.exists()) {
            return oldEmailFile;
        }
        return null;
    }

    private File getEmailFile(MessageId messageId, boolean newIndicator) {
        return new File(this.storageDir, (newIndicator ? (char)'N' : 'O') + "_" + messageId.toBase64() + EMAIL_FILE_EXTENSION);
    }

    public int getNumNewEmails() {
        int numNew = 0;
        for (File file : this.getFilenames()) {
            if (!this.isNew(file)) continue;
            ++numNew;
        }
        return numNew;
    }

    private boolean isNew(File file) {
        switch (file.getName().charAt(0)) {
            case 'N': {
                return true;
            }
            case 'O': {
                return false;
            }
        }
        throw new IllegalArgumentException("Illegal email filename, doesn't start with N or O: <" + file.getAbsolutePath() + ">");
    }

    public void setNew(String messageIdString, boolean isNew) {
        MessageId messageId = new MessageId(messageIdString);
        File file = this.getEmailFile(messageId);
        if (file != null) {
            char newIndicator = isNew ? (char)'N' : 'O';
            String newFilename = newIndicator + file.getName().substring(1);
            File newFile = new File(file.getParentFile(), newFilename);
            boolean success = file.renameTo(newFile);
            if (!success) {
                this.log.error("Cannot rename <" + file.getAbsolutePath() + "> to <" + newFile.getAbsolutePath() + ">");
            }
        } else {
            this.log.error("No email found for message Id: <" + messageId + ">");
        }
    }

    public boolean delete(String messageIdString) {
        MessageId messageId = new MessageId(messageIdString);
        File emailFile = this.getEmailFile(messageId);
        if (emailFile != null) {
            return emailFile.delete();
        }
        return false;
    }

    public void delete(Email email) {
        if (!this.getEmailFile(email).delete()) {
            this.log.error("Cannot delete file: '" + this.getEmailFile(email) + "'");
        }
    }

    protected Email createFolderElement(File file) throws Exception {
        FileInputStream inputStream = new FileInputStream(file);
        Email email = new Email((InputStream)inputStream);
        email.setNew(this.isNew(file));
        return email;
    }
}

