/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.email;

import i2p.bote.email.EmailIdentity;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public class Identities
implements Iterable<EmailIdentity> {
    private Log log = new Log(Identities.class);
    private File identitiesFile;
    private List<EmailIdentity> identities;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identities(File identitiesFile) {
        this.identitiesFile = identitiesFile;
        this.identities = Collections.synchronizedList(new ArrayList());
        if (!identitiesFile.exists()) {
            this.log.debug("Identities file does not exist: <" + identitiesFile.getAbsolutePath() + ">");
            return;
        }
        this.log.debug("Reading identities file: <" + identitiesFile.getAbsolutePath() + ">");
        BufferedReader input = null;
        try {
            String line;
            input = new BufferedReader(new FileReader(identitiesFile));
            while ((line = input.readLine()) != null) {
                EmailIdentity identity = this.parse(line);
                if (identity == null) continue;
                this.identities.add(identity);
            }
        }
        catch (IOException e) {
            this.log.error("Can't read identities file.", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    this.log.error("Error closing input stream.", (Throwable)e);
                }
            }
        }
    }

    private EmailIdentity parse(String emailIdentityString) {
        try {
            String[] fields = emailIdentityString.split("\\t", 4);
            if (fields.length < 2) {
                this.log.debug("Unparseable email identity: <" + emailIdentityString + ">");
                return null;
            }
            EmailIdentity identity = new EmailIdentity(fields[0]);
            if (fields.length > 1) {
                identity.setPublicName(fields[1]);
            }
            if (fields.length > 2) {
                identity.setDescription(fields[2]);
            }
            if (fields.length > 3) {
                identity.setEmailAddress(fields[3]);
            }
            return identity;
        }
        catch (PatternSyntaxException e) {
            this.log.debug("Unparseable email identity: <" + emailIdentityString + ">");
            return null;
        }
    }

    private String toFileFormat(EmailIdentity identity) {
        StringBuilder string = new StringBuilder();
        string = string.append(identity.getFullKey());
        string = string.append("\t");
        string = string.append(identity.getPublicName());
        string = string.append("\t");
        if (identity.getDescription() != null) {
            string = string.append(identity.getDescription());
        }
        string = string.append("\t");
        if (identity.getEmailAddress() != null) {
            string = string.append(identity.getEmailAddress());
        }
        return string.toString();
    }

    public void save() throws IOException {
        String newLine = System.getProperty("line.separator");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.identitiesFile));
            for (EmailIdentity identity : this.identities) {
                writer.write(this.toFileFormat(identity) + newLine);
            }
            ((Writer)writer).close();
        }
        catch (IOException e) {
            this.log.error("Can't save email identities to file <" + this.identitiesFile.getAbsolutePath() + ">.", (Throwable)e);
            throw e;
        }
    }

    public void add(EmailIdentity identity) {
        this.identities.add(identity);
    }

    public void remove(String key) {
        EmailIdentity identity = this.get(key);
        if (identity != null) {
            this.identities.remove(identity);
        }
    }

    public EmailIdentity get(int i) {
        return (EmailIdentity)this.identities.get(i);
    }

    public EmailIdentity get(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        for (EmailIdentity identity : this.identities) {
            if (!key.equals(identity.getKey())) continue;
            return identity;
        }
        return null;
    }

    public Collection<EmailIdentity> getAll() {
        return this.identities;
    }

    public EmailIdentity[] getArray() {
        return this.identities.toArray(new EmailIdentity[0]);
    }

    public int size() {
        return this.identities.size();
    }

    public boolean contains(Hash emailDestination) {
        return true;
    }

    @Override
    public Iterator<EmailIdentity> iterator() {
        return this.identities.iterator();
    }
}

