/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote.email;

import i2p.bote.email.EmailDestination;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.Base64;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.util.Log;

public class EmailIdentity
extends EmailDestination {
    private Log log = new Log(EmailIdentity.class);
    private PrivateKey privateEncryptionKey;
    private SigningPrivateKey privateSigningKey;
    private String publicName;
    private String description;
    private String emailAddress;

    public EmailIdentity() {
    }

    public EmailIdentity(String key) {
        try {
            key = key.substring(0, 512) + "AAAA" + key.substring(512);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.decode((String)key));
            I2PClient i2pClient = I2PClientFactory.createClient();
            I2PSession i2pSession = i2pClient.createSession((InputStream)inputStream, null);
            this.initKeys(i2pSession);
        }
        catch (I2PSessionException e) {
            this.log.error("Can't generate EmailIdentity.", (Throwable)e);
        }
    }

    public PrivateKey getPrivateEncryptionKey() {
        return this.privateEncryptionKey;
    }

    public SigningPrivateKey getPrivateSigningKey() {
        return this.privateSigningKey;
    }

    public void setPublicName(String publicName) {
        this.publicName = publicName;
    }

    public String getPublicName() {
        return this.publicName;
    }

    public void setDescription(String name) {
        this.description = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    protected void initKeys(I2PSession i2pSession) {
        super.initKeys(i2pSession);
        this.privateEncryptionKey = i2pSession.getDecryptionKey();
        this.privateSigningKey = i2pSession.getPrivateKey();
    }

    private byte[] getKeysAsArray() {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            byteStream.write(this.getPublicEncryptionKey().getData());
            byteStream.write(this.getPublicSigningKey().getData());
            byteStream.write(this.getPrivateEncryptionKey().getData());
            byteStream.write(this.getPrivateSigningKey().getData());
        }
        catch (IOException e) {
            this.log.error("Can't write to ByteArrayOutputStream.", (Throwable)e);
        }
        return byteStream.toByteArray();
    }

    public String getFullKey() {
        return Base64.encode((byte[])this.getKeysAsArray());
    }

    public String toString() {
        return this.getKey() + " address=<" + this.getEmailAddress() + "> identity name=<" + this.getDescription() + "> visible name=<" + this.getPublicName() + ">";
    }
}

