/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.i2p.data.Base64;
import net.i2p.util.RandomSource;

public class UniqueId
implements Comparable<UniqueId> {
    public static final byte LENGTH = 32;
    protected byte[] bytes = new byte[32];

    public UniqueId() {
        for (int i = 0; i < 32; ++i) {
            this.bytes[i] = (byte)RandomSource.getInstance().nextInt(256);
        }
    }

    public UniqueId(byte[] bytes, int offset) {
        System.arraycopy(bytes, offset, this.bytes, 0, 32);
    }

    public UniqueId(ByteBuffer buffer) {
        buffer.get(this.bytes);
    }

    public UniqueId(InputStream inputStream) throws IOException {
        inputStream.read(this.bytes);
    }

    public byte[] toByteArray() {
        return this.bytes;
    }

    public String toBase64() {
        return Base64.encode((byte[])this.bytes);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.bytes);
    }

    @Override
    public int compareTo(UniqueId otherPacketId) {
        return new BigInteger(this.bytes).compareTo(new BigInteger(otherPacketId.bytes));
    }

    public String toString() {
        return Base64.encode((byte[])this.bytes);
    }

    public boolean equals(Object anotherObject) {
        if (!(anotherObject instanceof UniqueId)) {
            return false;
        }
        UniqueId otherPacketId = (UniqueId)anotherObject;
        return Arrays.equals(this.bytes, otherPacketId.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public UniqueId clone() {
        UniqueId newUniqueId = new UniqueId();
        newUniqueId.bytes = (byte[])this.bytes.clone();
        return newUniqueId;
    }
}

