/*
 * Decompiled with CFR 0.152.
 */
package i2p.bote;

import i2p.bote.Configuration;
import i2p.bote.I2PBote;
import i2p.bote.Util;
import i2p.bote.email.Email;
import i2p.bote.email.EmailDestination;
import i2p.bote.email.EmailIdentity;
import i2p.bote.email.Identities;
import i2p.bote.folder.EmailFolder;
import i2p.bote.folder.EmailPacketFolder;
import i2p.bote.folder.IncompleteEmailFolder;
import i2p.bote.folder.IndexPacketFolder;
import i2p.bote.folder.Outbox;
import i2p.bote.folder.PacketFolder;
import i2p.bote.network.BanList;
import i2p.bote.network.BannedPeer;
import i2p.bote.network.CheckEmailTask;
import i2p.bote.network.DHT;
import i2p.bote.network.DhtPeer;
import i2p.bote.network.DhtStorageHandler;
import i2p.bote.network.I2PPacketDispatcher;
import i2p.bote.network.I2PSendQueue;
import i2p.bote.network.NetworkStatus;
import i2p.bote.network.PacketListener;
import i2p.bote.network.PeerManager;
import i2p.bote.network.kademlia.KademliaDHT;
import i2p.bote.packet.EncryptedEmailPacket;
import i2p.bote.packet.IndexPacket;
import i2p.bote.packet.RelayPacket;
import i2p.bote.packet.dht.DhtStorablePacket;
import i2p.bote.service.AutoMailCheckTask;
import i2p.bote.service.OutboxProcessor;
import i2p.bote.service.POP3Service;
import i2p.bote.service.RelayPacketSender;
import i2p.bote.service.SMTPService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.Log;

/*
 * Exception performing whole class analysis ignored.
 */
public class I2PBote {
    public static final int PROTOCOL_VERSION = 2;
    private static final String APP_VERSION = "0.2";
    private static final int STARTUP_DELAY = 180000;
    private static I2PBote instance;
    private Log log = new Log(I2PBote.class);
    private I2PAppContext appContext;
    private I2PClient i2pClient;
    private I2PSession i2pSession;
    private Configuration configuration;
    private Identities identities;
    private I2PSendQueue sendQueue;
    private Outbox outbox;
    private EmailFolder inbox;
    private PacketFolder<RelayPacket> relayPacketFolder;
    private IncompleteEmailFolder incompleteEmailFolder;
    private EmailPacketFolder emailDhtStorageFolder;
    private IndexPacketFolder indexPacketDhtStorageFolder;
    private SMTPService smtpService;
    private POP3Service pop3Service;
    private OutboxProcessor outboxProcessor;
    private AutoMailCheckTask autoMailCheckTask;
    private RelayPacketSender relayPacketSender;
    private DHT dht;
    private PeerManager peerManager;
    private ThreadFactory mailCheckThreadFactory;
    private ExecutorService mailCheckExecutor;
    private Collection<Future<Boolean>> pendingMailCheckTasks;
    private long lastMailCheckTime;
    private ConnectTask connectTask;
    private Future<?> connectTaskResult;

    private I2PBote() {
        Thread.currentThread().setName("I2PBoteMain");
        this.appContext = new I2PAppContext();
        this.i2pClient = I2PClientFactory.createClient();
        this.configuration = new Configuration();
        this.mailCheckThreadFactory = Util.createThreadFactory((String)"ChkMailTask", (int)65536);
        this.mailCheckExecutor = Executors.newFixedThreadPool(this.configuration.getMaxConcurIdCheckMail(), this.mailCheckThreadFactory);
        this.identities = new Identities(this.configuration.getIdentitiesFile());
        this.initializeFolderAccess();
        this.connectTask = new ConnectTask(this, null);
        this.connectTaskResult = Executors.newSingleThreadExecutor().submit((Runnable)this.connectTask);
    }

    private void initializeFolderAccess() {
        this.inbox = new EmailFolder(this.configuration.getInboxDir());
        this.outbox = new Outbox(this.configuration.getLocalOutboxDir());
        this.relayPacketFolder = new PacketFolder(this.configuration.getRelayOutboxDir());
        this.incompleteEmailFolder = new IncompleteEmailFolder(this.configuration.getIncompleteDir(), this.inbox);
        this.emailDhtStorageFolder = new EmailPacketFolder(this.configuration.getEmailDhtStorageDir());
        this.indexPacketDhtStorageFolder = new IndexPacketFolder(this.configuration.getIndexPacketDhtStorageDir());
    }

    private void initializeSession() {
        Properties sessionProperties = new Properties();
        sessionProperties.setProperty("inbound.nickname", "I2P-Bote");
        sessionProperties.setProperty("outbound.nickname", "I2P-Bote");
        sessionProperties.setProperty("i2cp.gzip", String.valueOf(false));
        File destinationKeyFile = this.configuration.getDestinationKeyFile();
        try {
            FileReader fileReader = new FileReader(destinationKeyFile);
            char[] destKeyBuffer = new char[(int)destinationKeyFile.length()];
            fileReader.read(destKeyBuffer);
            byte[] localDestinationKey = Base64.decode((String)new String(destKeyBuffer));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(localDestinationKey);
            this.i2pSession = this.i2pClient.createSession((InputStream)inputStream, sessionProperties);
            this.i2pSession.connect();
        }
        catch (IOException e) {
            this.log.debug("Destination key file doesn't exist or isn't readable: " + e);
        }
        catch (I2PSessionException e) {
            this.log.warn("Error creating I2PSession", (Throwable)e);
        }
        if (this.i2pSession == null) {
            this.log.debug("Creating new local destination key");
            try {
                ByteArrayOutputStream arrayStream = new ByteArrayOutputStream();
                this.i2pClient.createDestination((OutputStream)arrayStream);
                byte[] localDestinationArray = arrayStream.toByteArray();
                this.i2pSession = this.i2pClient.createSession((InputStream)new ByteArrayInputStream(localDestinationArray), sessionProperties);
                this.i2pSession.connect();
                this.saveLocalDestinationKeys(destinationKeyFile, localDestinationArray);
            }
            catch (I2PException e) {
                this.log.error("Error creating local destination key or I2PSession.", (Throwable)e);
            }
            catch (IOException e) {
                this.log.error("Error writing local destination key to file.", (Throwable)e);
            }
        }
        Destination localDestination = this.i2pSession.getMyDestination();
        this.log.debug("Local destination key = " + localDestination.toBase64());
        this.log.debug("Local destination hash = " + localDestination.calculateHash().toBase64());
    }

    private void initializeServices() {
        I2PPacketDispatcher dispatcher = new I2PPacketDispatcher();
        this.i2pSession.addSessionListener((I2PSessionListener)dispatcher, 0, 0);
        this.smtpService = new SMTPService();
        this.pop3Service = new POP3Service();
        this.relayPacketSender = new RelayPacketSender(this.sendQueue, this.relayPacketFolder, this.appContext);
        this.sendQueue = new I2PSendQueue(this.i2pSession, dispatcher);
        this.dht = new KademliaDHT(this.i2pSession.getMyDestination(), this.sendQueue, dispatcher, this.configuration.getPeerFile());
        this.dht.setStorageHandler(EncryptedEmailPacket.class, (DhtStorageHandler)this.emailDhtStorageFolder);
        this.dht.setStorageHandler(IndexPacket.class, (DhtStorageHandler)this.indexPacketDhtStorageFolder);
        dispatcher.addPacketListener((PacketListener)this.emailDhtStorageFolder);
        dispatcher.addPacketListener((PacketListener)this.indexPacketDhtStorageFolder);
        this.peerManager = new PeerManager();
        this.outboxProcessor = new OutboxProcessor(this.dht, this.outbox, this.configuration, this.peerManager, this.appContext);
        this.autoMailCheckTask = new AutoMailCheckTask(this.configuration.getMailCheckInterval());
    }

    private void saveLocalDestinationKeys(File keyFile, byte[] localDestinationArray) throws DataFormatException, IOException {
        if (keyFile.exists()) {
            File oldKeyFile = new File(keyFile.getPath() + "_backup");
            keyFile.renameTo(oldKeyFile);
        } else {
            keyFile.createNewFile();
        }
        FileWriter fileWriter = new FileWriter(keyFile);
        fileWriter.write(Base64.encode((byte[])localDestinationArray));
        fileWriter.close();
    }

    public static void startUp() {
        I2PBote.getInstance();
    }

    public static void shutDown() {
        if (instance != null) {
            instance.stopAllServices();
        }
    }

    public static I2PBote getInstance() {
        if (instance == null) {
            instance = new I2PBote();
        }
        return instance;
    }

    public String getAppVersion() {
        return "0.2";
    }

    public Identities getIdentities() {
        return this.identities;
    }

    public Destination getLocalDestination() {
        return this.i2pSession.getMyDestination();
    }

    public void sendEmail(Email email) throws Exception {
        email.updateHeaders();
        String recipient = (String)email.getAllRecipients().iterator().next();
        EmailDestination emailDestination = new EmailDestination(recipient);
        Collection emailPackets = email.createEmailPackets(recipient);
        Collection encryptedPackets = EncryptedEmailPacket.encrypt((Collection)emailPackets, (EmailDestination)emailDestination, (I2PAppContext)this.appContext);
        for (EncryptedEmailPacket packet : encryptedPackets) {
            this.dht.store((DhtStorablePacket)packet);
        }
        this.dht.store((DhtStorablePacket)new IndexPacket(encryptedPackets, emailDestination));
    }

    public synchronized void checkForMail() {
        if (!this.isCheckingForMail()) {
            this.log.debug("Checking for mail...");
            this.lastMailCheckTime = System.currentTimeMillis();
            this.pendingMailCheckTasks = Collections.synchronizedCollection(new ArrayList());
            for (EmailIdentity identity : this.getIdentities()) {
                CheckEmailTask checkMailTask = new CheckEmailTask(identity, this.dht, this.peerManager, this.sendQueue, this.incompleteEmailFolder, this.appContext);
                Future task = this.mailCheckExecutor.submit(checkMailTask);
                this.pendingMailCheckTasks.add(task);
            }
        } else {
            this.log.debug("Not checking for mail because the last one hasn't finished.");
        }
    }

    public synchronized long getLastMailCheckTime() {
        return this.lastMailCheckTime;
    }

    public synchronized boolean isCheckingForMail() {
        if (this.pendingMailCheckTasks == null) {
            return false;
        }
        for (Future task : this.pendingMailCheckTasks) {
            if (task.isDone()) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean newMailReceived() {
        if (this.pendingMailCheckTasks == null) {
            return false;
        }
        if (this.isCheckingForMail()) {
            return false;
        }
        try {
            for (Future result : this.pendingMailCheckTasks) {
                if (!((Boolean)result.get(1L, TimeUnit.MILLISECONDS)).booleanValue()) continue;
                this.pendingMailCheckTasks = null;
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("Error while checking whether new mail has arrived.", (Throwable)e);
        }
        this.pendingMailCheckTasks = null;
        return false;
    }

    public EmailFolder getInbox() {
        return this.inbox;
    }

    public int getNumDhtPeers() {
        return this.dht.getNumPeers();
    }

    public Collection<? extends DhtPeer> getDhtPeers() {
        return this.dht.getPeers();
    }

    public Collection<BannedPeer> getBannedPeers() {
        return BanList.getInstance().getAll();
    }

    private void startAllServices() {
        this.dht.start();
        this.outboxProcessor.start();
        this.relayPacketSender.start();
        this.smtpService.start();
        this.pop3Service.start();
        this.sendQueue.start();
        this.autoMailCheckTask.start();
    }

    private void stopAllServices() {
        this.dht.shutDown();
        this.outboxProcessor.shutDown();
        this.relayPacketSender.requestShutdown();
        this.smtpService.shutDown();
        this.pop3Service.shutDown();
        this.sendQueue.requestShutdown();
        this.mailCheckExecutor.shutdownNow();
        this.autoMailCheckTask.shutDown();
    }

    public void connectNow() {
        this.connectTask.startSignal.countDown();
    }

    public NetworkStatus getNetworkStatus() {
        if (!this.connectTaskResult.isDone()) {
            return this.connectTask.getNetworkStatus();
        }
        if (this.dht != null) {
            return this.dht.isConnected() ? NetworkStatus.CONNECTED : NetworkStatus.CONNECTING;
        }
        return NetworkStatus.ERROR;
    }

    static /* synthetic */ void access$100(I2PBote x0) {
        x0.initializeSession();
    }

    static /* synthetic */ void access$200(I2PBote x0) {
        x0.initializeServices();
    }

    static /* synthetic */ void access$300(I2PBote x0) {
        x0.startAllServices();
    }

    static /* synthetic */ Log access$400(I2PBote x0) {
        return x0.log;
    }
}

