/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObjectParser;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public abstract class ASN1TaggedObject
extends ASN1Object
implements ASN1TaggedObjectParser {
    int tagNo;
    boolean empty = false;
    boolean explicit = true;
    DEREncodable obj = null;

    public static ASN1TaggedObject getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            return (ASN1TaggedObject)obj.getObject();
        }
        throw new IllegalArgumentException("implicitly tagged tagged object");
    }

    public static ASN1TaggedObject getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)obj;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public ASN1TaggedObject(int tagNo, DEREncodable obj) {
        this.explicit = true;
        this.tagNo = tagNo;
        this.obj = obj;
    }

    public ASN1TaggedObject(boolean explicit, int tagNo, DEREncodable obj) {
        this.explicit = obj instanceof ASN1Choice ? true : explicit;
        this.tagNo = tagNo;
        this.obj = obj;
    }

    @Override
    boolean asn1Equals(DERObject o) {
        if (!(o instanceof ASN1TaggedObject)) {
            return false;
        }
        ASN1TaggedObject other = (ASN1TaggedObject)o;
        if (this.tagNo != other.tagNo || this.empty != other.empty || this.explicit != other.explicit) {
            return false;
        }
        return !(this.obj == null ? other.obj != null : !this.obj.getDERObject().equals(other.obj.getDERObject()));
    }

    @Override
    public int hashCode() {
        int code = this.tagNo;
        if (this.obj != null) {
            code ^= this.obj.hashCode();
        }
        return code;
    }

    @Override
    public int getTagNo() {
        return this.tagNo;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public DERObject getObject() {
        if (this.obj != null) {
            return this.obj.getDERObject();
        }
        return null;
    }

    @Override
    public DEREncodable getObjectParser(int tag, boolean isExplicit) {
        switch (tag) {
            case 17: {
                return ASN1Set.getInstance(this, isExplicit).parser();
            }
            case 16: {
                return ASN1Sequence.getInstance(this, isExplicit).parser();
            }
            case 4: {
                return ASN1OctetString.getInstance(this, isExplicit).parser();
            }
        }
        if (isExplicit) {
            return this.getObject();
        }
        throw new RuntimeException("implicit tagging not implemented for tag: " + tag);
    }

    @Override
    abstract void encode(DEROutputStream var1) throws IOException;

    public String toString() {
        return "[" + this.tagNo + "]" + this.obj;
    }
}

