/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.BERApplicationSpecificParser;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERExternalParser;
import org.bouncycastle.asn1.DEROctetStringParser;
import org.bouncycastle.asn1.DERSequenceParser;
import org.bouncycastle.asn1.DERSetParser;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;

public class ASN1StreamParser {
    private final InputStream _in;
    private final int _limit;

    private static int findLimit(InputStream in) {
        if (in instanceof DefiniteLengthInputStream) {
            return ((DefiniteLengthInputStream)in).getRemaining();
        }
        return Integer.MAX_VALUE;
    }

    public ASN1StreamParser(InputStream in) {
        this(in, ASN1StreamParser.findLimit(in));
    }

    public ASN1StreamParser(InputStream in, int limit) {
        this._in = in;
        this._limit = limit;
    }

    public ASN1StreamParser(byte[] encoding) {
        this(new ByteArrayInputStream(encoding), encoding.length);
    }

    public DEREncodable readObject() throws IOException {
        int tag = this._in.read();
        if (tag == -1) {
            return null;
        }
        this.set00Check(false);
        int tagNo = ASN1InputStream.readTagNumber(this._in, tag);
        boolean isConstructed = (tag & 0x20) != 0;
        int length = ASN1InputStream.readLength(this._in, this._limit);
        if (length < 0) {
            if (!isConstructed) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indIn = new IndefiniteLengthInputStream(this._in);
            if ((tag & 0x40) != 0) {
                ASN1StreamParser sp = new ASN1StreamParser(indIn, this._limit);
                return new BERApplicationSpecificParser(tagNo, sp);
            }
            if ((tag & 0x80) != 0) {
                return new BERTaggedObjectParser(tag, tagNo, indIn);
            }
            ASN1StreamParser sp = new ASN1StreamParser(indIn, this._limit);
            switch (tagNo) {
                case 4: {
                    return new BEROctetStringParser(sp);
                }
                case 16: {
                    return new BERSequenceParser(sp);
                }
                case 17: {
                    return new BERSetParser(sp);
                }
                case 8: {
                    return new DERExternalParser(sp);
                }
            }
            throw new IOException("unknown BER object encountered: 0x" + Integer.toHexString(tagNo));
        }
        DefiniteLengthInputStream defIn = new DefiniteLengthInputStream(this._in, length);
        if ((tag & 0x40) != 0) {
            return new DERApplicationSpecific(isConstructed, tagNo, defIn.toByteArray());
        }
        if ((tag & 0x80) != 0) {
            return new BERTaggedObjectParser(tag, tagNo, defIn);
        }
        if (isConstructed) {
            switch (tagNo) {
                case 4: {
                    return new BEROctetStringParser(new ASN1StreamParser(defIn));
                }
                case 16: {
                    return new DERSequenceParser(new ASN1StreamParser(defIn));
                }
                case 17: {
                    return new DERSetParser(new ASN1StreamParser(defIn));
                }
                case 8: {
                    return new DERExternalParser(new ASN1StreamParser(defIn));
                }
            }
            return new DERUnknownTag(true, tagNo, defIn.toByteArray());
        }
        switch (tagNo) {
            case 4: {
                return new DEROctetStringParser(defIn);
            }
        }
        return ASN1InputStream.createPrimitiveDERObject(tagNo, defIn.toByteArray());
    }

    private void set00Check(boolean enabled) {
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(enabled);
        }
    }

    ASN1EncodableVector readVector() throws IOException {
        DEREncodable obj;
        ASN1EncodableVector v = new ASN1EncodableVector();
        while ((obj = this.readObject()) != null) {
            v.add(obj.getDERObject());
        }
        return v;
    }
}

