/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.GZIPInputStream;
import net.i2p.data.DataHelper;
import net.i2p.util.ResettableGZIPOutputStream;

public class ReusableGZIPOutputStream
extends ResettableGZIPOutputStream {
    private static final boolean ENABLE_CACHING = !System.getProperty("java.vendor").startsWith("Apache");
    private static final LinkedBlockingQueue<ReusableGZIPOutputStream> _available = ENABLE_CACHING ? new LinkedBlockingQueue(16) : null;
    private ByteArrayOutputStream _buffer = (ByteArrayOutputStream)this.out;

    public static ReusableGZIPOutputStream acquire() {
        ReusableGZIPOutputStream rv = null;
        if (ENABLE_CACHING) {
            rv = _available.poll();
        }
        if (rv == null) {
            rv = new ReusableGZIPOutputStream();
        }
        return rv;
    }

    public static void release(ReusableGZIPOutputStream out) {
        out.reset();
        if (ENABLE_CACHING) {
            _available.offer(out);
        }
    }

    private ReusableGZIPOutputStream() {
        super(new ByteArrayOutputStream(40960));
    }

    public void reset() {
        super.reset();
        this._buffer.reset();
        this.def.setLevel(9);
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    public byte[] getData() {
        return this._buffer.toByteArray();
    }

    public static void main(String[] args) {
        try {
            int i;
            for (i = 0; i < 2; ++i) {
                ReusableGZIPOutputStream.test();
            }
            for (i = 500; i < 65536 && ReusableGZIPOutputStream.test(i); ++i) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("After all tests are complete...");
    }

    private static void test() {
        byte[] b = "hi, how are you today?".getBytes();
        try {
            ReusableGZIPOutputStream o = ReusableGZIPOutputStream.acquire();
            o.write(b);
            o.finish();
            o.flush();
            byte[] compressed = o.getData();
            ReusableGZIPOutputStream.release(o);
            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(compressed));
            byte[] rv = new byte[128];
            int read = in.read(rv);
            if (!DataHelper.eq(rv, 0, b, 0, b.length)) {
                throw new RuntimeException("foo, read=" + read);
            }
            System.out.println("match, w00t");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean test(int size) {
        byte[] b = new byte[size];
        new Random().nextBytes(b);
        try {
            int read;
            ReusableGZIPOutputStream o = ReusableGZIPOutputStream.acquire();
            o.write(b);
            o.finish();
            o.flush();
            byte[] compressed = o.getData();
            ReusableGZIPOutputStream.release(o);
            GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(compressed));
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream(262144);
            byte[] rbuf = new byte[128];
            while ((read = in.read(rbuf)) != -1) {
                baos2.write(rbuf, 0, read);
            }
            byte[] rv = baos2.toByteArray();
            if (!DataHelper.eq(rv, 0, b, 0, b.length)) {
                throw new RuntimeException("foo, read=" + rv.length);
            }
            System.out.println("match, w00t @ " + size);
            return true;
        }
        catch (Exception e) {
            System.out.println("Error on size=" + size + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

