/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import net.i2p.I2PAppContext;
import net.i2p.util.EepGet;

public class PartialEepGet
extends EepGet {
    long _fetchSize;

    public PartialEepGet(I2PAppContext ctx, String proxyHost, int proxyPort, OutputStream outputStream, String url, long size) {
        super(ctx, true, proxyHost, proxyPort, 0, size, size, null, outputStream, url, true, null, null);
        this._fetchSize = size;
    }

    public static void main(String[] args) {
        PartialEepGet get;
        FileOutputStream out;
        String proxyHost = "127.0.0.1";
        int proxyPort = 4444;
        long size = 56L;
        String url = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-p")) {
                    proxyHost = args[i + 1].substring(0, args[i + 1].indexOf(58));
                    String port = args[i + 1].substring(args[i + 1].indexOf(58) + 1);
                    proxyPort = Integer.parseInt(port);
                    ++i;
                    continue;
                }
                if (args[i].equals("-l")) {
                    size = Long.parseLong(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].startsWith("-")) {
                    PartialEepGet.usage();
                    return;
                }
                url = args[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PartialEepGet.usage();
            return;
        }
        if (url == null) {
            PartialEepGet.usage();
            return;
        }
        String saveAs = PartialEepGet.suggestName(url);
        try {
            out = new FileOutputStream(saveAs);
        }
        catch (IOException ioe) {
            System.err.println("Failed to create output file " + saveAs);
            return;
        }
        PartialEepGet partialEepGet = get = new PartialEepGet(I2PAppContext.getGlobalContext(), proxyHost, proxyPort, out, url, size);
        partialEepGet.getClass();
        get.addStatusListener(partialEepGet.new EepGet.CLIStatusListener(1024, 40));
        if (get.fetch(45000L, -1L, 60000L)) {
            System.err.println("Last-Modified: " + get.getLastModified());
            System.err.println("Etag: " + get.getETag());
        } else {
            System.err.println("Failed " + url);
        }
    }

    private static void usage() {
        System.err.println("PartialEepGet [-p 127.0.0.1:4444] [-l #bytes] url");
    }

    protected String getRequest() throws IOException {
        StringBuilder buf = new StringBuilder(2048);
        URL url = new URL(this._actualURL);
        String proto = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        String query = url.getQuery();
        if (query != null) {
            path = path + '?' + query;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        path = port == 80 || port == 443 || port <= 0 ? proto + "://" + host + path : proto + "://" + host + ":" + port + path;
        if (this._log.shouldLog(10)) {
            this._log.debug("Requesting " + path);
        }
        buf.append("GET ").append(this._actualURL).append(" HTTP/1.1\r\n");
        buf.append("Host: ").append(url.getHost()).append("\r\n");
        buf.append("Range: bytes=");
        buf.append(this._alreadyTransferred);
        buf.append('-');
        buf.append(this._fetchSize - 1L);
        buf.append("\r\n");
        if (this._shouldProxy) {
            buf.append("X-Accept-Encoding: x-i2p-gzip;q=1.0, identity;q=0.5, deflate;q=0, gzip;q=0, *;q=0\r\n");
        }
        buf.append("Cache-control: no-cache\r\nPragma: no-cache\r\n");
        buf.append("User-Agent: Wget/1.11.4\r\nAccept-Encoding: \r\nConnection: close\r\n\r\n");
        if (this._log.shouldLog(10)) {
            this._log.debug("Request: [" + buf.toString() + "]");
        }
        return buf.toString();
    }
}

