/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import freenet.support.CPUInformation.AMDCPUInfo;
import freenet.support.CPUInformation.CPUID;
import freenet.support.CPUInformation.CPUInfo;
import freenet.support.CPUInformation.IntelCPUInfo;
import freenet.support.CPUInformation.UnknownCPUException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Random;
import net.i2p.I2PAppContext;
import net.i2p.util.FileUtil;

public class NativeBigInteger
extends BigInteger {
    private static boolean _nativeOk = false;
    private static String _loadStatus = "uninitialized";
    private static String _cpuModel = "uninitialized";
    private static final boolean _doLog = System.getProperty("jbigi.dontLog") == null;
    private static final String JBIGI_OPTIMIZATION_K6 = "k6";
    private static final String JBIGI_OPTIMIZATION_K6_2 = "k62";
    private static final String JBIGI_OPTIMIZATION_K6_3 = "k63";
    private static final String JBIGI_OPTIMIZATION_ATHLON = "athlon";
    private static final String JBIGI_OPTIMIZATION_ATHLON64 = "athlon64";
    private static final String JBIGI_OPTIMIZATION_PENTIUM = "pentium";
    private static final String JBIGI_OPTIMIZATION_PENTIUMMMX = "pentiummmx";
    private static final String JBIGI_OPTIMIZATION_PENTIUM2 = "pentium2";
    private static final String JBIGI_OPTIMIZATION_PENTIUM3 = "pentium3";
    private static final String JBIGI_OPTIMIZATION_PENTIUM4 = "pentium4";
    private static final String JBIGI_OPTIMIZATION_VIAC3 = "viac3";
    private static final boolean _isWin = System.getProperty("os.name").startsWith("Win");
    private static final boolean _isOS2 = System.getProperty("os.name").startsWith("OS/2");
    private static final boolean _isMac = System.getProperty("os.name").startsWith("Mac");
    private static final boolean _isLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
    private static final boolean _isFreebsd = System.getProperty("os.name").toLowerCase().indexOf("freebsd") != -1;
    private static final boolean _isNix = !_isWin && !_isMac && !_isOS2;
    private static final String _libPrefix;
    private static final String _libSuffix;
    private static final String sCPUType;
    private byte[] cachedBa;
    private static final byte[] _sampleGenerator;
    private static final byte[] _samplePrime;

    private static String resolveCPUType() {
        boolean is64;
        boolean bl = is64 = -1 != System.getProperty("os.arch").indexOf("64");
        if (is64) {
            return JBIGI_OPTIMIZATION_ATHLON64;
        }
        try {
            CPUInfo c = CPUID.getInfo();
            try {
                _cpuModel = c.getCPUModelString();
            }
            catch (UnknownCPUException e) {
                // empty catch block
            }
            if (c.IsC3Compatible()) {
                return JBIGI_OPTIMIZATION_VIAC3;
            }
            if (c instanceof AMDCPUInfo) {
                AMDCPUInfo amdcpu = (AMDCPUInfo)c;
                if (amdcpu.IsAthlon64Compatible()) {
                    return JBIGI_OPTIMIZATION_ATHLON64;
                }
                if (amdcpu.IsAthlonCompatible()) {
                    return JBIGI_OPTIMIZATION_ATHLON;
                }
                if (amdcpu.IsK6_3_Compatible()) {
                    return JBIGI_OPTIMIZATION_K6_3;
                }
                if (amdcpu.IsK6_2_Compatible()) {
                    return JBIGI_OPTIMIZATION_K6_2;
                }
                if (amdcpu.IsK6Compatible()) {
                    return JBIGI_OPTIMIZATION_K6;
                }
            } else if (c instanceof IntelCPUInfo) {
                IntelCPUInfo intelcpu = (IntelCPUInfo)c;
                if (intelcpu.IsPentium4Compatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM4;
                }
                if (intelcpu.IsPentium3Compatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM3;
                }
                if (intelcpu.IsPentium2Compatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM2;
                }
                if (intelcpu.IsPentiumMMXCompatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUMMMX;
                }
                if (intelcpu.IsPentiumCompatible()) {
                    return JBIGI_OPTIMIZATION_PENTIUM;
                }
            }
            return null;
        }
        catch (UnknownCPUException e) {
            return null;
        }
    }

    public static native byte[] nativeModPow(byte[] var0, byte[] var1, byte[] var2);

    public static native double nativeDoubleValue(byte[] var0);

    public NativeBigInteger(byte[] val) {
        super(val);
    }

    public NativeBigInteger(int signum, byte[] magnitude) {
        super(signum, magnitude);
    }

    public NativeBigInteger(int bitlen, int certainty, Random rnd) {
        super(bitlen, certainty, rnd);
    }

    public NativeBigInteger(int numbits, Random rnd) {
        super(numbits, rnd);
    }

    public NativeBigInteger(String val) {
        super(val);
    }

    public NativeBigInteger(String val, int radix) {
        super(val, radix);
    }

    public NativeBigInteger(BigInteger integer) {
        this(integer.toByteArray());
    }

    public BigInteger modPow(BigInteger exponent, BigInteger m) {
        if (_nativeOk) {
            return new NativeBigInteger(NativeBigInteger.nativeModPow(this.toByteArray(), exponent.toByteArray(), m.toByteArray()));
        }
        return super.modPow(exponent, m);
    }

    public byte[] toByteArray() {
        if (this.cachedBa == null) {
            this.cachedBa = super.toByteArray();
        }
        return this.cachedBa;
    }

    public double doubleValue() {
        if (_nativeOk) {
            return NativeBigInteger.nativeDoubleValue(this.toByteArray());
        }
        return super.doubleValue();
    }

    public static boolean isNative() {
        return _nativeOk;
    }

    public static String loadStatus() {
        return _loadStatus;
    }

    public static String cpuType() {
        if (sCPUType != null) {
            return sCPUType;
        }
        return "unrecognized";
    }

    public static String cpuModel() {
        return _cpuModel;
    }

    public static void main(String[] args) {
        NativeBigInteger.runModPowTest(100);
    }

    private static void runModPowTest(int numRuns) {
        System.out.println("DEBUG: Warming up the random number generator...");
        SecureRandom rand = new SecureRandom();
        rand.nextBoolean();
        System.out.println("DEBUG: Random number generator warmed up");
        BigInteger jg = new BigInteger(_sampleGenerator);
        BigInteger jp = new BigInteger(_samplePrime);
        long totalTime = 0L;
        long javaTime = 0L;
        int runsProcessed = 0;
        for (runsProcessed = 0; runsProcessed < numRuns; ++runsProcessed) {
            BigInteger bi = new BigInteger(226, rand);
            NativeBigInteger g = new NativeBigInteger(_sampleGenerator);
            NativeBigInteger p = new NativeBigInteger(_samplePrime);
            NativeBigInteger k = new NativeBigInteger(1, bi.toByteArray());
            long beforeModPow = System.currentTimeMillis();
            BigInteger myValue = g.modPow(k, p);
            long afterModPow = System.currentTimeMillis();
            BigInteger jval = jg.modPow(bi, jp);
            long afterJavaModPow = System.currentTimeMillis();
            totalTime += afterModPow - beforeModPow;
            javaTime += afterJavaModPow - afterModPow;
            if (!myValue.equals(jval)) {
                System.err.println("ERROR: [" + runsProcessed + "]\tnative modPow != java modPow");
                System.err.println("ERROR: native modPow value: " + myValue.toString());
                System.err.println("ERROR: java modPow value: " + jval.toString());
                System.err.println("ERROR: run time: " + totalTime + "ms (" + totalTime / (long)(runsProcessed + 1) + "ms each)");
                break;
            }
            System.out.println("DEBUG: current run time: " + (afterModPow - beforeModPow) + "ms (total: " + totalTime + "ms, " + totalTime / (long)(runsProcessed + 1) + "ms each)");
        }
        System.out.println("INFO: run time: " + totalTime + "ms (" + totalTime / (long)(runsProcessed + 1) + "ms each)");
        if (numRuns == runsProcessed) {
            System.out.println("INFO: " + runsProcessed + " runs complete without any errors");
        } else {
            System.out.println("ERROR: " + runsProcessed + " runs until we got an error");
        }
        if (_nativeOk) {
            System.out.println("native run time: \t" + totalTime + "ms (" + totalTime / (long)(runsProcessed + 1) + "ms each)");
            System.out.println("java run time:   \t" + javaTime + "ms (" + javaTime / (long)(runsProcessed + 1) + "ms each)");
            System.out.println("native = " + (double)totalTime * 100.0 / (double)javaTime + "% of pure java time");
        } else {
            System.out.println("java run time: \t" + javaTime + "ms (" + javaTime / (long)(runsProcessed + 1) + "ms each)");
            System.out.println("However, we couldn't load the native library, so this doesn't test much");
        }
    }

    private static void runDoubleValueTest(int numRuns) {
        System.out.println("DEBUG: Warming up the random number generator...");
        SecureRandom rand = new SecureRandom();
        rand.nextBoolean();
        System.out.println("DEBUG: Random number generator warmed up");
        BigInteger jg = new BigInteger(_sampleGenerator);
        long totalTime = 0L;
        long javaTime = 0L;
        int MULTIPLICATOR = 50000;
        int runsProcessed = 0;
        for (runsProcessed = 0; runsProcessed < numRuns; ++runsProcessed) {
            NativeBigInteger g = new NativeBigInteger(_sampleGenerator);
            long beforeDoubleValue = System.currentTimeMillis();
            double dNative = 0.0;
            for (int mult = 0; mult < MULTIPLICATOR; ++mult) {
                dNative = g.doubleValue();
            }
            long afterDoubleValue = System.currentTimeMillis();
            double jval = 0.0;
            for (int mult = 0; mult < MULTIPLICATOR; ++mult) {
                jval = jg.doubleValue();
            }
            long afterJavaDoubleValue = System.currentTimeMillis();
            totalTime += afterDoubleValue - beforeDoubleValue;
            javaTime += afterJavaDoubleValue - afterDoubleValue;
            if (dNative != jval) {
                System.err.println("ERROR: [" + runsProcessed + "]\tnative double != java double");
                System.err.println("ERROR: native double value: " + dNative);
                System.err.println("ERROR: java double value: " + jval);
                System.err.println("ERROR: run time: " + totalTime + "ms (" + totalTime / (long)(runsProcessed + 1) + "ms each)");
                break;
            }
            System.out.println("DEBUG: current run time: " + (afterDoubleValue - beforeDoubleValue) + "ms (total: " + totalTime + "ms, " + totalTime / (long)(runsProcessed + 1) + "ms each)");
        }
        System.out.println("INFO: run time: " + totalTime + "ms (" + totalTime / (long)(runsProcessed + 1) + "ms each)");
        if (numRuns == runsProcessed) {
            System.out.println("INFO: " + runsProcessed + " runs complete without any errors");
        } else {
            System.out.println("ERROR: " + runsProcessed + " runs until we got an error");
        }
        if (_nativeOk) {
            System.out.println("native run time: \t" + totalTime + "ms (" + totalTime / (long)(runsProcessed + 1) + "ms each)");
            System.out.println("java run time:   \t" + javaTime + "ms (" + javaTime / (long)(runsProcessed + 1) + "ms each)");
            System.out.println("native = " + (double)totalTime * 100.0 / (double)javaTime + "% of pure java time");
        } else {
            System.out.println("java run time: \t" + javaTime + "ms (" + javaTime / (long)(runsProcessed + 1) + "ms each)");
            System.out.println("However, we couldn't load the native library, so this doesn't test much");
        }
    }

    private static final void loadNative() {
        try {
            String wantedProp = System.getProperty("jbigi.enable", "true");
            boolean wantNative = "true".equalsIgnoreCase(wantedProp);
            if (wantNative) {
                boolean loaded = NativeBigInteger.loadGeneric("jbigi");
                if (loaded) {
                    _nativeOk = true;
                    NativeBigInteger.info("Locally optimized native BigInteger library loaded from the library path");
                } else {
                    loaded = NativeBigInteger.loadFromResource("jbigi");
                    if (loaded) {
                        _nativeOk = true;
                        NativeBigInteger.info("Locally optimized native BigInteger library loaded from resource");
                    } else {
                        loaded = NativeBigInteger.loadFromResource(true);
                        if (loaded) {
                            _nativeOk = true;
                            NativeBigInteger.info("Optimized native BigInteger library '" + NativeBigInteger.getResourceName(true) + "' loaded from resource");
                        } else {
                            loaded = NativeBigInteger.loadGeneric(true);
                            if (loaded) {
                                _nativeOk = true;
                                NativeBigInteger.info("Optimized native BigInteger library '" + NativeBigInteger.getMiddleName(true) + "' loaded from somewhere in the path");
                            } else {
                                loaded = NativeBigInteger.loadFromResource(false);
                                if (loaded) {
                                    _nativeOk = true;
                                    NativeBigInteger.info("Non-optimized native BigInteger library '" + NativeBigInteger.getResourceName(false) + "' loaded from resource");
                                } else {
                                    loaded = NativeBigInteger.loadGeneric(false);
                                    if (loaded) {
                                        _nativeOk = true;
                                        NativeBigInteger.info("Non-optimized native BigInteger library '" + NativeBigInteger.getMiddleName(false) + "' loaded from somewhere in the path");
                                    } else {
                                        _nativeOk = false;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (!_nativeOk) {
                NativeBigInteger.warn("Native BigInteger library jbigi not loaded - using pure Java - poor performance may result - see http://www.i2p2.i2p/jbigi.html for help");
            }
        }
        catch (Exception e) {
            NativeBigInteger.warn("Native BigInteger library jbigi not loaded, reason: '" + e.getMessage() + "' - using pure java");
        }
    }

    private static void info(String s) {
        if (_doLog) {
            System.err.println("INFO: " + s);
        }
        I2PAppContext.getGlobalContext().logManager().getLog(NativeBigInteger.class).info(s);
        _loadStatus = s;
    }

    private static void warn(String s) {
        if (_doLog) {
            System.err.println("WARNING: " + s);
        }
        I2PAppContext.getGlobalContext().logManager().getLog(NativeBigInteger.class).warn(s);
        _loadStatus = s;
    }

    private static final boolean loadGeneric(boolean optimized) {
        return NativeBigInteger.loadGeneric(NativeBigInteger.getMiddleName(optimized));
    }

    private static final boolean loadGeneric(String name) {
        try {
            if (name == null) {
                return false;
            }
            System.loadLibrary(name);
            return true;
        }
        catch (UnsatisfiedLinkError ule) {
            return false;
        }
    }

    private static final boolean loadFromResource(boolean optimized) {
        String resourceName = NativeBigInteger.getResourceName(optimized);
        return NativeBigInteger.loadFromResource(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean loadFromResource(String resourceName) {
        if (resourceName == null) {
            return false;
        }
        URL resource = ClassLoader.getSystemResource(resourceName);
        if (resource == null) {
            if (_doLog) {
                System.err.println("NOTICE: Resource name [" + resourceName + "] was not found");
            }
            return false;
        }
        File outFile = null;
        FileOutputStream fos = null;
        String filename = _libPrefix + "jbigi" + _libSuffix;
        try {
            int read;
            InputStream libStream = resource.openStream();
            outFile = new File(I2PAppContext.getGlobalContext().getTempDir(), filename);
            fos = new FileOutputStream(outFile);
            byte[] buf = new byte[4096];
            while ((read = libStream.read(buf)) >= 0) {
                fos.write(buf, 0, read);
            }
            fos.close();
            fos = null;
            System.load(outFile.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError ule) {
            if (_doLog) {
                System.err.println("ERROR: The resource " + resourceName + " was not a valid library for this platform");
                ule.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            if (_doLog) {
                System.err.println("ERROR: Problem writing out the temporary native library data");
                ioe.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
        File newFile = new File(I2PAppContext.getGlobalContext().getBaseDir(), filename);
        FileUtil.copy(outFile.getAbsolutePath(), newFile.getAbsolutePath(), false, true);
        return true;
    }

    private static final String getResourceName(boolean optimized) {
        String pref = _libPrefix;
        String middle = NativeBigInteger.getMiddleName(optimized);
        String suff = _libSuffix;
        if (pref == null || middle == null || suff == null) {
            return null;
        }
        return pref + middle + suff;
    }

    private static final String getMiddleName(boolean optimized) {
        String sAppend;
        if (optimized) {
            if (sCPUType == null) {
                return null;
            }
            sAppend = "-" + sCPUType;
        } else {
            sAppend = "-none";
        }
        if (_isWin) {
            return "jbigi-windows" + sAppend;
        }
        if (_isLinux) {
            return "jbigi-linux" + sAppend;
        }
        if (_isFreebsd) {
            return "jbigi-freebsd" + sAppend;
        }
        if (_isMac) {
            return "jbigi-osx" + sAppend;
        }
        if (_isOS2) {
            return "jbigi-os2" + sAppend;
        }
        throw new RuntimeException("Dont know jbigi library name for os type '" + System.getProperty("os.name") + "'");
    }

    static {
        String string = _libPrefix = _isWin || _isOS2 ? "" : "lib";
        _libSuffix = _isWin || _isOS2 ? ".dll" : (_isMac ? ".jnilib" : ".so");
        sCPUType = _isMac ? null : NativeBigInteger.resolveCPUType();
        NativeBigInteger.loadNative();
        _sampleGenerator = new BigInteger("2").toByteArray();
        _samplePrime = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AACAA68FFFFFFFFFFFFFFFF", 16).toByteArray();
    }
}

