/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.util.Clock;
import net.i2p.util.LogManager;
import net.i2p.util.LogRecord;
import net.i2p.util.LogRecordFormatter;

class LogWriter
implements Runnable {
    private static final long CONFIG_READ_ITERVAL = 10000L;
    private long _lastReadConfig = 0L;
    private long _numBytesInCurrentFile = 0L;
    private Writer _currentOut;
    private int _rotationNum = -1;
    private String _logFilenamePattern;
    private File _currentFile;
    private LogManager _manager;
    private boolean _write;

    private LogWriter() {
    }

    public LogWriter(LogManager manager) {
        this._manager = manager;
        this._lastReadConfig = Clock.getInstance().now();
    }

    public void stopWriting() {
        this._write = false;
    }

    public void run() {
        this._write = true;
        try {
            this.rotateFile();
            while (this._write) {
                this.flushRecords();
                this.rereadConfig();
            }
        }
        catch (Exception e) {
            System.err.println("Error writing the logs: " + e.getMessage());
            e.printStackTrace();
        }
        this.closeFile();
    }

    public void flushRecords() {
        this.flushRecords(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushRecords(boolean shouldWait) {
        try {
            List<LogRecord> records = this._manager._removeAll();
            if (records == null) {
                return;
            }
            Iterator<LogRecord> i$ = records.iterator();
            while (i$.hasNext()) {
                LogRecord rec = i$.next();
                this.writeRecord(rec);
            }
            if (!records.isEmpty()) {
                try {
                    this._currentOut.flush();
                }
                catch (IOException ioe) {
                    System.err.println("Error flushing the records");
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (shouldWait) {
                try {
                    LogWriter logWriter = this;
                    synchronized (logWriter) {
                        this.wait(10000L);
                    }
                }
                catch (InterruptedException ie) {}
            }
        }
    }

    public String currentFile() {
        return this._currentFile != null ? this._currentFile.getAbsolutePath() : "uninitialized";
    }

    private void rereadConfig() {
        long now = Clock.getInstance().now();
        if (now - this._lastReadConfig > 10000L) {
            this._manager.rereadConfig();
            this._lastReadConfig = now;
        }
    }

    private void writeRecord(LogRecord rec) {
        String val = LogRecordFormatter.formatRecord(this._manager, rec);
        this.writeRecord(val);
        this._manager.getBuffer().add(val);
        if (rec.getPriority() >= 50) {
            this._manager.getBuffer().addCritical(val);
        }
        if (this._manager.getDisplayOnScreenLevel() <= rec.getPriority() && this._manager.displayOnScreen()) {
            System.out.print(val);
        }
    }

    private void writeRecord(String val) {
        if (val == null) {
            return;
        }
        if (this._currentOut == null) {
            this.rotateFile();
            if (this._currentOut == null) {
                return;
            }
        }
        try {
            this._currentOut.write(val);
            this._numBytesInCurrentFile += (long)val.length();
        }
        catch (Throwable t) {
            if (!this._write) {
                return;
            }
            System.err.println("Error writing log, disk full? " + t);
        }
        if (this._numBytesInCurrentFile >= (long)this._manager.getFileSize()) {
            this.rotateFile();
        }
    }

    private void rotateFile() {
        File f;
        String pattern = this._manager.getBaseLogfilename();
        this._currentFile = f = this.getNextFile(pattern);
        this._numBytesInCurrentFile = 0L;
        File parent = f.getParentFile();
        if (parent != null) {
            boolean ok;
            if (!parent.exists() && !(ok = parent.mkdirs())) {
                System.err.println("Unable to create the parent directory: " + parent.getAbsolutePath());
            }
            if (!parent.isDirectory()) {
                System.err.println("Cannot put the logs in a subdirectory of a plain file: " + f.getAbsolutePath());
            }
        }
        this.closeFile();
        try {
            this._currentOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
        }
        catch (IOException ioe) {
            System.err.println("Error rotating into [" + f.getAbsolutePath() + "]" + ioe);
        }
    }

    private void closeFile() {
        Writer out = this._currentOut;
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private File getNextFile(String pattern) {
        File f = new File(pattern);
        File base = null;
        if (!f.isAbsolute()) {
            base = I2PAppContext.getGlobalContext().getLogDir();
        }
        if (pattern.indexOf(35) < 0 && pattern.indexOf(64) <= 0) {
            if (base != null) {
                return new File(base, pattern);
            }
            return f;
        }
        int max = this._manager.getRotationLimit();
        if (this._rotationNum == -1) {
            return this.getFirstFile(base, pattern, max);
        }
        ++this._rotationNum;
        if (this._rotationNum > max) {
            this._rotationNum = 0;
        }
        String newf = LogWriter.replace(pattern, this._rotationNum);
        if (base != null) {
            return new File(base, newf);
        }
        return new File(newf);
    }

    private File getFirstFile(File base, String pattern, int max) {
        for (int i = 0; i < max; ++i) {
            File f = base != null ? new File(base, LogWriter.replace(pattern, i)) : new File(LogWriter.replace(pattern, i));
            if (f.exists()) continue;
            this._rotationNum = i;
            return f;
        }
        File oldest = null;
        for (int i = 0; i < max; ++i) {
            File f = base != null ? new File(base, LogWriter.replace(pattern, i)) : new File(LogWriter.replace(pattern, i));
            if (oldest == null) {
                oldest = f;
                continue;
            }
            if (f.lastModified() >= oldest.lastModified()) continue;
            this._rotationNum = i;
            oldest = f;
        }
        return oldest;
    }

    private static final String replace(String pattern, int num) {
        char[] c = pattern.toCharArray();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != '#' && c[i] != '@') {
                buf.append(c[i]);
                continue;
            }
            buf.append(num);
        }
        return buf.toString();
    }
}

