/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import net.i2p.I2PAppContext;
import net.i2p.util.EepGet;
import net.i2p.util.SocketTimeout;

public class EepHead
extends EepGet {
    static final OutputStream _dummyStream = new ByteArrayOutputStream(0);

    public EepHead(I2PAppContext ctx, String proxyHost, int proxyPort, int numRetries, String url) {
        super(ctx, true, proxyHost, proxyPort, numRetries, -1L, -1L, null, _dummyStream, url, true, null, null);
    }

    public static void main(String[] args) {
        String proxyHost = "127.0.0.1";
        int proxyPort = 4444;
        int numRetries = 0;
        int inactivityTimeout = 60000;
        String url = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-p")) {
                    proxyHost = args[i + 1].substring(0, args[i + 1].indexOf(58));
                    String port = args[i + 1].substring(args[i + 1].indexOf(58) + 1);
                    proxyPort = Integer.parseInt(port);
                    ++i;
                    continue;
                }
                if (args[i].equals("-n")) {
                    numRetries = Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-t")) {
                    inactivityTimeout = 1000 * Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].startsWith("-")) {
                    EepHead.usage();
                    return;
                }
                url = args[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EepHead.usage();
            return;
        }
        if (url == null) {
            EepHead.usage();
            return;
        }
        EepHead get = new EepHead(I2PAppContext.getGlobalContext(), proxyHost, proxyPort, numRetries, url);
        if (get.fetch(45000L, -1L, inactivityTimeout)) {
            System.err.println("Content-Type: " + get.getContentType());
            System.err.println("Content-Length: " + get.getContentLength());
            System.err.println("Last-Modified: " + get.getLastModified());
            System.err.println("Etag: " + get.getETag());
        } else {
            System.err.println("Failed " + url);
        }
    }

    private static void usage() {
        System.err.println("EepHead [-p 127.0.0.1:4444] [-n #retries] [-t timeout] url");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFetch(SocketTimeout timeout) throws IOException {
        this._headersRead = false;
        this._aborted = false;
        try {
            this.readHeaders();
        }
        finally {
            this._headersRead = true;
        }
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP headers");
        }
        timeout.resetTimer();
        if (this._fetchInactivityTimeout > 0L) {
            timeout.setInactivityTimeout(this._fetchInactivityTimeout);
        } else {
            timeout.setInactivityTimeout(60000L);
        }
        if (this._redirectLocation != null) {
            URL oldURL = new URL(this._actualURL);
            String query = oldURL.getQuery();
            if (query == null) {
                query = "";
            }
            if (this._redirectLocation.startsWith("http://")) {
                this._actualURL = this._redirectLocation.indexOf(63) < 0 && query.length() > 0 ? this._redirectLocation + "?" + query : this._redirectLocation;
            } else {
                URL url = new URL(this._actualURL);
                this._actualURL = this._redirectLocation.startsWith("/") ? "http://" + url.getHost() + ":" + url.getPort() + this._redirectLocation : "http://" + url.getHost() + ":" + url.getPort() + "/" + this._redirectLocation;
                if (this._actualURL.indexOf(63) < 0 && query.length() > 0) {
                    this._actualURL = this._actualURL + "?" + query;
                }
            }
            ++this._redirects;
            if (this._redirects > 5) {
                throw new IOException("Too many redirects: to " + this._redirectLocation);
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Redirecting to " + this._redirectLocation);
            }
            this.sendRequest(timeout);
            this.doFetch(timeout);
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Headers read completely");
        }
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP data");
        }
        timeout.cancel();
        if (this._transferFailed) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).attemptFailed(this._url, 0L, 0L, this._currentAttempt, this._numRetries, new Exception("Attempt failed"));
            }
        } else {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).transferComplete(0L, 0L, 0L, this._url, "dummy", false);
            }
        }
    }

    protected String getRequest() throws IOException {
        StringBuilder buf = new StringBuilder(512);
        URL url = new URL(this._actualURL);
        String proto = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        String path = url.getPath();
        String query = url.getQuery();
        if (query != null) {
            path = path + "?" + query;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        path = port == 80 || port == 443 || port <= 0 ? proto + "://" + host + path : proto + "://" + host + ":" + port + path;
        if (this._log.shouldLog(10)) {
            this._log.debug("Requesting " + path);
        }
        buf.append("HEAD ").append(this._actualURL).append(" HTTP/1.1\r\n");
        buf.append("Host: ").append(url.getHost()).append("\r\n");
        buf.append("Accept-Encoding: \r\n");
        if (this._shouldProxy) {
            buf.append("X-Accept-Encoding: x-i2p-gzip;q=1.0, identity;q=0.5, deflate;q=0, gzip;q=0, *;q=0\r\n");
        }
        buf.append("User-Agent: Wget/1.11.4\r\n");
        buf.append("Connection: close\r\n\r\n");
        if (this._log.shouldLog(10)) {
            this._log.debug("Request: [" + buf.toString() + "]");
        }
        return buf.toString();
    }

    public long getContentLength() {
        return this._bytesRemaining;
    }
}

