/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.stat;

import java.text.Collator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.stat.BufferedStatLog;
import net.i2p.stat.FrequencyStat;
import net.i2p.stat.RateStat;
import net.i2p.stat.StatLog;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatManager {
    private Log _log;
    private I2PAppContext _context;
    private final Map<String, FrequencyStat> _frequencyStats;
    private final Map<String, RateStat> _rateStats;
    private StatLog _statLog;
    public static final String PROP_STAT_FILTER = "stat.logFilters";
    public static final String PROP_STAT_FILE = "stat.logFile";
    public static final String DEFAULT_STAT_FILE = "stats.log";
    public static final String PROP_STAT_FULL = "stat.full";
    public static final String PROP_STAT_REQUIRED = "stat.required";
    public static final String DEFAULT_STAT_REQUIRED = "bw.recvRate,bw.sendBps,bw.sendRate,client.sendAckTime,clock.skew,crypto.elGamal.encrypt,jobQueue.jobLag,netDb.successTime,peer.failedLookupRate,router.fastPeers,prng.bufferFillTime,prng.bufferWaitTime,router.memoryUsed,transport.receiveMessageSize,transport.sendMessageSize,transport.sendProcessingTime,tunnel.acceptLoad,tunnel.buildRequestTime,tunnel.rejectOverloaded,tunnel.rejectTimeouttunnel.buildClientExpire,tunnel.buildClientReject,tunnel.buildClientSuccess,tunnel.buildExploratoryExpire,tunnel.buildExploratoryReject,tunnel.buildExploratorySuccess,tunnel.buildRatio.*,tunnel.corruptMessage,tunnel.dropLoad*,tunnel.decryptRequestTime,tunnel.fragmentedDropped,tunnel.participatingMessageCount,tunnel.participatingTunnels,tunnel.testFailedTime,tunnel.testSuccessTime,tunnel.participatingBandwidth,udp.sendPacketSize,udp.packetsRetransmitted,udp.sendException";

    public StatManager(I2PAppContext context) {
        this._log = context.logManager().getLog(StatManager.class);
        this._context = context;
        this._frequencyStats = Collections.synchronizedMap(new HashMap(8));
        this._rateStats = new HashMap<String, RateStat>(128);
        if (this.getStatFilter() != null) {
            this._statLog = new BufferedStatLog(context);
        }
    }

    public StatLog getStatLog() {
        return this._statLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatLog(StatLog log) {
        this._statLog = log;
        Map<String, RateStat> map = this._rateStats;
        synchronized (map) {
            for (RateStat rs : this._rateStats.values()) {
                rs.setStatLog(log);
            }
        }
    }

    public void createFrequencyStat(String name, String description, String group, long[] periods) {
        if (this.ignoreStat(name)) {
            return;
        }
        if (this._frequencyStats.containsKey(name)) {
            return;
        }
        this._frequencyStats.put(name, new FrequencyStat(name, description, group, periods));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRateStat(String name, String description, String group, long[] periods) {
        if (this.ignoreStat(name)) {
            return;
        }
        Map<String, RateStat> map = this._rateStats;
        synchronized (map) {
            if (this._rateStats.containsKey(name)) {
                return;
            }
            RateStat rs = new RateStat(name, description, group, periods);
            if (this._statLog != null) {
                rs.setStatLog(this._statLog);
            }
            this._rateStats.put(name, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRateStat(String name) {
        Map<String, RateStat> map = this._rateStats;
        synchronized (map) {
            this._rateStats.remove(name);
        }
    }

    public void updateFrequency(String name) {
        FrequencyStat freq = this._frequencyStats.get(name);
        if (freq != null) {
            freq.eventOccurred();
        }
    }

    public void addRateData(String name, long data, long eventDuration) {
        RateStat stat = this._rateStats.get(name);
        if (stat != null) {
            stat.addData(data, eventDuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coalesceStats() {
        Map<String, Object> map = this._frequencyStats;
        synchronized (map) {
            for (FrequencyStat frequencyStat : this._frequencyStats.values()) {
                if (frequencyStat == null) continue;
                frequencyStat.coalesceStats();
            }
        }
        map = this._rateStats;
        synchronized (map) {
            for (RateStat rateStat : this._rateStats.values()) {
                if (rateStat == null) continue;
                rateStat.coalesceStats();
            }
        }
    }

    public FrequencyStat getFrequency(String name) {
        return this._frequencyStats.get(name);
    }

    public RateStat getRate(String name) {
        return this._rateStats.get(name);
    }

    public Set<String> getFrequencyNames() {
        return new HashSet<String>(this._frequencyStats.keySet());
    }

    public Set<String> getRateNames() {
        return new HashSet<String>(this._rateStats.keySet());
    }

    public boolean isRate(String statName) {
        return this._rateStats.containsKey(statName);
    }

    public boolean isFrequency(String statName) {
        return this._frequencyStats.containsKey(statName);
    }

    public Map getStatsByGroup() {
        Set names;
        TreeMap groups = new TreeMap(Collator.getInstance());
        for (FrequencyStat frequencyStat : this._frequencyStats.values()) {
            if (!groups.containsKey(frequencyStat.getGroupName())) {
                groups.put(frequencyStat.getGroupName(), new TreeSet());
            }
            names = (Set)groups.get(frequencyStat.getGroupName());
            names.add(frequencyStat.getName());
        }
        for (RateStat rateStat : this._rateStats.values()) {
            if (!groups.containsKey(rateStat.getGroupName())) {
                groups.put(rateStat.getGroupName(), new TreeSet());
            }
            names = (Set)groups.get(rateStat.getGroupName());
            names.add(rateStat.getName());
        }
        return groups;
    }

    public String getStatFilter() {
        return this._context.getProperty(PROP_STAT_FILTER);
    }

    public String getStatFile() {
        return this._context.getProperty(PROP_STAT_FILE, DEFAULT_STAT_FILE);
    }

    public boolean ignoreStat(String statName) {
        if (this._context.getBooleanPropertyDefaultTrue(PROP_STAT_FULL)) {
            return false;
        }
        String required = this._context.getProperty(PROP_STAT_REQUIRED, DEFAULT_STAT_REQUIRED);
        String[] req = required.split(",");
        for (int i = 0; i < req.length; ++i) {
            if (req[i].equals(statName)) {
                return false;
            }
            if (!req[i].endsWith("*") || !statName.startsWith(req[i].substring(0, req[i].length() - 2))) continue;
            return false;
        }
        return true;
    }
}

