/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageHandler;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class I2CPMessageReader {
    private static final Log _log = new Log(I2CPMessageReader.class);
    private InputStream _stream;
    private I2CPMessageEventListener _listener;
    private I2CPMessageReaderRunner _reader;
    private Thread _readerThread;
    private static volatile long __readerId = 0L;

    public I2CPMessageReader(InputStream stream, I2CPMessageEventListener lsnr) {
        this._stream = stream;
        this.setListener(lsnr);
        this._reader = new I2CPMessageReaderRunner();
        this._readerThread = new I2PThread(this._reader);
        this._readerThread.setDaemon(true);
        this._readerThread.setName("I2CP Reader " + ++__readerId);
    }

    public void setListener(I2CPMessageEventListener lsnr) {
        this._listener = lsnr;
    }

    public I2CPMessageEventListener getListener() {
        return this._listener;
    }

    public void startReading() {
        this._readerThread.start();
    }

    public void pauseReading() {
        this._reader.pauseRunner();
    }

    public void resumeReading() {
        this._reader.resumeRunner();
    }

    public void stopReading() {
        this._reader.cancelRunner();
    }

    private class I2CPMessageReaderRunner
    implements Runnable {
        private volatile boolean _doRun = true;
        private volatile boolean _stayAlive = true;

        public void pauseRunner() {
            this._doRun = false;
        }

        public void resumeRunner() {
            this._doRun = true;
        }

        public void cancelRunner() {
            this._doRun = false;
            this._stayAlive = false;
            InputStream in = I2CPMessageReader.this._stream;
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    _log.error("Error closing the stream", ioe);
                }
            }
        }

        public void run() {
            while (this._stayAlive) {
                while (this._doRun) {
                    try {
                        I2CPMessage msg = I2CPMessageHandler.readMessage(I2CPMessageReader.this._stream);
                        if (msg == null) continue;
                        _log.debug("Before handling the newly received message");
                        I2CPMessageReader.this._listener.messageReceived(I2CPMessageReader.this, msg);
                        _log.debug("After handling the newly received message");
                    }
                    catch (I2CPMessageException ime) {
                        _log.warn("Error handling message", ime);
                        I2CPMessageReader.this._listener.readError(I2CPMessageReader.this, ime);
                        this.cancelRunner();
                    }
                    catch (IOException ioe) {
                        _log.warn("IO Error handling message", ioe);
                        I2CPMessageReader.this._listener.disconnected(I2CPMessageReader.this);
                        this.cancelRunner();
                    }
                    catch (OutOfMemoryError oom) {
                        throw oom;
                    }
                    catch (Exception e) {
                        _log.log(50, "Unhandled error reading I2CP stream", e);
                        I2CPMessageReader.this._listener.disconnected(I2CPMessageReader.this);
                        this.cancelRunner();
                    }
                }
                if (this._doRun) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    _log.warn("Breaking away stream", ie);
                    I2CPMessageReader.this._listener.disconnected(I2CPMessageReader.this);
                    this.cancelRunner();
                }
            }
            I2CPMessageReader.this._stream = null;
        }
    }

    public static interface I2CPMessageEventListener {
        public void messageReceived(I2CPMessageReader var1, I2CPMessage var2);

        public void readError(I2CPMessageReader var1, Exception var2);

        public void disconnected(I2CPMessageReader var1);
    }
}

