/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.util.RandomSource;

public class SessionTag
extends ByteArray {
    public static final int BYTE_LENGTH = 32;

    public SessionTag() {
    }

    public SessionTag(boolean create) {
        if (create) {
            byte[] buf = new byte[32];
            RandomSource.getInstance().nextBytes(buf);
            this.setData(buf);
        }
    }

    public SessionTag(byte[] val) {
        this.setData(val);
    }

    public void setData(byte[] val) throws IllegalArgumentException {
        if (val == null) {
            throw new NullPointerException("SessionTags cannot be null");
        }
        if (val.length != 32) {
            throw new IllegalArgumentException("SessionTags must be 32 bytes");
        }
        super.setData(val);
        this.setValid(32);
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        byte[] data = new byte[32];
        int read = DataHelper.read(in, data);
        if (read != 32) {
            throw new DataFormatException("Not enough data (read " + read + " wanted " + 32 + ")");
        }
        this.setData(data);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        out.write(this.getData());
    }

    public String toString() {
        return "SessionTag " + this.toBase64();
    }
}

