/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RoutingKeyGenerator;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterInfo
extends DataStructureImpl {
    private static final Log _log = new Log(RouterInfo.class);
    private RouterIdentity _identity;
    private volatile long _published;
    private final Set<RouterAddress> _addresses;
    private final Set<Hash> _peers;
    private Properties _options;
    private volatile Signature _signature;
    private volatile Hash _currentRoutingKey;
    private volatile byte[] _routingKeyGenMod;
    private volatile boolean _validated;
    private volatile boolean _isValid;
    private volatile String _stringified;
    private volatile byte[] _byteified;
    private volatile int _hashCode;
    private volatile boolean _hashCodeInitialized;
    public static final String PROP_NETWORK_ID = "netId";
    public static final String PROP_CAPABILITIES = "caps";
    public static final char CAPABILITY_HIDDEN = 'H';
    public static final String BW_CAPABILITY_CHARS = "KLMNO";

    public RouterInfo() {
        this.setIdentity(null);
        this.setPublished(0L);
        this._addresses = new HashSet<RouterAddress>(2);
        this._peers = new HashSet<Hash>(0);
        this._options = new OrderedProperties();
        this.setSignature(null);
        this._validated = false;
        this._isValid = false;
        this._currentRoutingKey = null;
        this._stringified = null;
        this._byteified = null;
        this._hashCodeInitialized = false;
    }

    public RouterInfo(RouterInfo old) {
        this();
        this.setIdentity(old.getIdentity());
        this.setPublished(old.getPublished());
        this.setAddresses(old.getAddresses());
        this.setPeers(old.getPeers());
        this.setOptions(old.getOptions());
        this.setSignature(old.getSignature());
    }

    private void resetCache() {
        this._stringified = null;
        this._byteified = null;
        this._hashCodeInitialized = false;
    }

    public RouterIdentity getIdentity() {
        return this._identity;
    }

    public void setIdentity(RouterIdentity ident) {
        this._identity = ident;
        this.resetCache();
    }

    public long getPublished() {
        return this._published;
    }

    public void setPublished(long published) {
        this._published = published;
        this.resetCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RouterAddress> getAddresses() {
        Set<RouterAddress> set = this._addresses;
        synchronized (set) {
            return new HashSet<RouterAddress>(this._addresses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddresses(Set<RouterAddress> addresses) {
        Set<RouterAddress> set = this._addresses;
        synchronized (set) {
            this._addresses.clear();
            if (addresses != null) {
                this._addresses.addAll(addresses);
            }
        }
        this.resetCache();
    }

    public Set<Hash> getPeers() {
        return this._peers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeers(Set<Hash> peers) {
        Set<Hash> set = this._peers;
        synchronized (set) {
            this._peers.clear();
            if (peers != null) {
                this._peers.addAll(peers);
            }
        }
        this.resetCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getOptions() {
        if (this._options == null) {
            return new Properties();
        }
        Properties properties = this._options;
        synchronized (properties) {
            return (Properties)this._options.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOption(String opt) {
        if (this._options == null) {
            return null;
        }
        Properties properties = this._options;
        synchronized (properties) {
            return this._options.getProperty(opt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptions(Properties options) {
        Properties properties = this._options;
        synchronized (properties) {
            this._options.clear();
            if (options != null) {
                for (String string : options.keySet()) {
                    String val;
                    if (string == null || (val = options.getProperty(string)) == null) continue;
                    this._options.setProperty(string, val);
                }
            }
        }
        this.resetCache();
    }

    public Signature getSignature() {
        return this._signature;
    }

    public void setSignature(Signature signature) {
        this._signature = signature;
        this.resetCache();
    }

    public synchronized void sign(SigningPrivateKey key) throws DataFormatException {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            throw new DataFormatException("Not enough data to sign");
        }
        Signature sig = DSAEngine.getInstance().sign(bytes, key);
        if (sig == null) {
            throw new DataFormatException("Not enough data to sign, or other signature failure");
        }
        this.setSignature(sig);
    }

    private byte[] getBytes() throws DataFormatException {
        if (this._byteified != null) {
            return this._byteified;
        }
        if (this._identity == null) {
            throw new DataFormatException("Router identity isn't set? wtf!");
        }
        if (this._addresses == null) {
            throw new DataFormatException("Router addressess isn't set? wtf!");
        }
        if (this._peers == null) {
            throw new DataFormatException("Router peers isn't set? wtf!");
        }
        if (this._options == null) {
            throw new DataFormatException("Router options isn't set? wtf!");
        }
        long before = Clock.getInstance().now();
        ByteArrayOutputStream out = new ByteArrayOutputStream(6144);
        try {
            this._identity.writeBytes(out);
            DataHelper.writeDate(out, new Date(this._published));
            if (this.isHidden()) {
                DataHelper.writeLong(out, 1, 0L);
            } else {
                DataHelper.writeLong(out, 1, this._addresses.size());
                List addresses = DataHelper.sortStructures(this._addresses);
                for (RouterAddress addr : addresses) {
                    addr.writeBytes(out);
                }
            }
            DataHelper.writeLong(out, 1, this._peers.size());
            List peers = DataHelper.sortStructures(this._peers);
            for (Hash peerHash : peers) {
                peerHash.writeBytes(out);
            }
            DataHelper.writeProperties(out, this._options);
        }
        catch (IOException ioe) {
            throw new DataFormatException("IO Error getting bytes", ioe);
        }
        byte[] data = out.toByteArray();
        long after = Clock.getInstance().now();
        _log.debug("getBytes()  took " + (after - before) + "ms");
        this._byteified = data;
        return data;
    }

    public synchronized boolean isValid() {
        if (!this._validated) {
            this.doValidate();
        }
        return this._isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNetworkId() {
        if (this._options == null) {
            return -1;
        }
        String id = null;
        Properties properties = this._options;
        synchronized (properties) {
            id = this._options.getProperty(PROP_NETWORK_ID);
        }
        if (id != null) {
            try {
                return Integer.parseInt(id);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCapabilities() {
        if (this._options == null) {
            return "";
        }
        String capabilities = null;
        Properties properties = this._options;
        synchronized (properties) {
            capabilities = this._options.getProperty(PROP_CAPABILITIES);
        }
        if (capabilities != null) {
            return capabilities;
        }
        return "";
    }

    public boolean isHidden() {
        return this.getCapabilities().indexOf(72) != -1;
    }

    public String getBandwidthTier() {
        String bwTiers = BW_CAPABILITY_CHARS;
        String bwTier = "Unknown";
        String capabilities = this.getCapabilities();
        for (int i = 0; i < capabilities.length(); ++i) {
            if (bwTiers.indexOf(String.valueOf(capabilities.charAt(i))) == -1) continue;
            bwTier = String.valueOf(capabilities.charAt(i));
            break;
        }
        return bwTier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCapability(char cap) {
        if (this._options == null) {
            this._options = new OrderedProperties();
        }
        Properties properties = this._options;
        synchronized (properties) {
            String caps = this._options.getProperty(PROP_CAPABILITIES);
            if (caps == null) {
                this._options.setProperty(PROP_CAPABILITIES, "" + cap);
            } else if (caps.indexOf(cap) == -1) {
                this._options.setProperty(PROP_CAPABILITIES, caps + cap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delCapability(char cap) {
        if (this._options == null) {
            return;
        }
        Properties properties = this._options;
        synchronized (properties) {
            String caps = this._options.getProperty(PROP_CAPABILITIES);
            if (caps == null) {
                return;
            }
            int idx = caps.indexOf(cap);
            if (idx == -1) {
                return;
            }
            StringBuilder buf = new StringBuilder(caps);
            while ((idx = buf.indexOf("" + cap)) != -1) {
                buf.deleteCharAt(idx);
            }
            this._options.setProperty(PROP_CAPABILITIES, buf.toString());
        }
    }

    public synchronized Hash getRoutingKey() {
        RoutingKeyGenerator gen = RoutingKeyGenerator.getInstance();
        if (gen.getModData() == null || this._routingKeyGenMod == null || !DataHelper.eq(gen.getModData(), this._routingKeyGenMod)) {
            this.setRoutingKey(gen.getRoutingKey(this._identity.getHash()));
            this._routingKeyGenMod = gen.getModData();
        }
        return this._currentRoutingKey;
    }

    public void setRoutingKey(Hash key) {
        this._currentRoutingKey = key;
    }

    public boolean validateRoutingKey() {
        Hash identKey = this._identity.getHash();
        Hash rk = RoutingKeyGenerator.getInstance().getRoutingKey(identKey);
        return rk.equals(this.getRoutingKey());
    }

    public boolean isCurrent(long maxAgeMs) {
        long earliestExpire = Clock.getInstance().now() - maxAgeMs;
        return this._published >= earliestExpire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RouterAddress getTargetAddress(String transportStyle) {
        Set<RouterAddress> set = this._addresses;
        synchronized (set) {
            for (RouterAddress addr : this._addresses) {
                if (!addr.getTransportStyle().equals(transportStyle)) continue;
                return addr;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RouterAddress> getTargetAddresses(String transportStyle) {
        Vector<RouterAddress> ret = new Vector<RouterAddress>();
        Set<RouterAddress> set = this._addresses;
        synchronized (set) {
            for (RouterAddress o : this._addresses) {
                RouterAddress addr = o;
                if (!addr.getTransportStyle().equals(transportStyle)) continue;
                ret.add(addr);
            }
        }
        return ret;
    }

    private synchronized void doValidate() {
        this._validated = true;
        if (this.getSignature() == null) {
            _log.error("Signature is null");
            this._isValid = false;
            return;
        }
        byte[] data = null;
        try {
            data = this.getBytes();
        }
        catch (DataFormatException dfe) {
            _log.error("Error validating", dfe);
            this._isValid = false;
            return;
        }
        if (data == null) {
            _log.error("Data could not be loaded");
            this._isValid = false;
            return;
        }
        this._isValid = DSAEngine.getInstance().verifySignature(this._signature, data, this._identity.getSigningPublicKey());
        if (!this._isValid) {
            if (_log.shouldLog(40)) {
                _log.error("Invalid [" + SHA256Generator.getInstance().calculateHash(data).toBase64() + "] w/ signing key: " + this._identity.getSigningPublicKey(), new Exception("Signature failed"));
            }
            if (_log.shouldLog(10)) {
                _log.debug("Failed data: \n" + Base64.encode(data));
                _log.debug("Signature: " + this.getSignature());
            }
        }
    }

    @Override
    public synchronized void readBytes(InputStream in) throws DataFormatException, IOException {
        this._identity = new RouterIdentity();
        this._identity.readBytes(in);
        Date when = DataHelper.readDate(in);
        this._published = when == null ? 0L : when.getTime();
        int numAddresses = (int)DataHelper.readLong(in, 1);
        for (int i = 0; i < numAddresses; ++i) {
            RouterAddress address = new RouterAddress();
            address.readBytes(in);
            this._addresses.add(address);
        }
        int numPeers = (int)DataHelper.readLong(in, 1);
        for (int i = 0; i < numPeers; ++i) {
            Hash peerIdentityHash = new Hash();
            peerIdentityHash.readBytes(in);
            this._peers.add(peerIdentityHash);
        }
        this._options = DataHelper.readProperties(in);
        this._signature = new Signature();
        this._signature.readBytes(in);
        this.resetCache();
    }

    @Override
    public synchronized void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._identity == null) {
            throw new DataFormatException("Missing identity");
        }
        if (this._published < 0L) {
            throw new DataFormatException("Invalid published date: " + this._published);
        }
        if (this._signature == null) {
            throw new DataFormatException("Signature is null");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        baos.write(this.getBytes());
        this._signature.writeBytes(baos);
        byte[] data = baos.toByteArray();
        out.write(data);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RouterInfo)) {
            return false;
        }
        RouterInfo info = (RouterInfo)object;
        return DataHelper.eq(this._identity, info.getIdentity()) && DataHelper.eq(this._signature, info.getSignature()) && DataHelper.eq(this._published, info.getPublished()) && DataHelper.eq(this._addresses, info.getAddresses()) && DataHelper.eq(this._options, info.getOptions()) && DataHelper.eq(this._peers, info.getPeers());
    }

    public int hashCode() {
        if (!this._hashCodeInitialized) {
            this._hashCode = DataHelper.hashCode(this._identity) + (int)this._published;
            this._hashCodeInitialized = true;
        }
        return this._hashCode;
    }

    public String toString() {
        if (this._stringified != null) {
            return this._stringified;
        }
        StringBuilder buf = new StringBuilder(5120);
        buf.append("[RouterInfo: ");
        buf.append("\n\tIdentity: ").append(this._identity);
        buf.append("\n\tSignature: ").append(this._signature);
        buf.append("\n\tPublished on: ").append(new Date(this._published));
        Set<RouterAddress> addresses = this._addresses;
        buf.append("\n\tAddresses: #: ").append(addresses.size());
        for (RouterAddress addr : addresses) {
            buf.append("\n\t\tAddress: ").append(addr);
        }
        Set<Hash> peers = this._peers;
        buf.append("\n\tPeers: #: ").append(peers.size());
        for (Hash hash : peers) {
            buf.append("\n\t\tPeer hash: ").append(hash);
        }
        Properties options = this._options;
        buf.append("\n\tOptions: #: ").append(options.size());
        for (String string : options.keySet()) {
            String val = options.getProperty(string);
            buf.append("\n\t\t[").append(string).append("] = [").append(val).append("]");
        }
        buf.append("]");
        this._stringified = buf.toString();
        return this._stringified;
    }
}

