/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Log;

public class RouterIdentity
extends DataStructureImpl {
    private static final Log _log = new Log(RouterIdentity.class);
    private Certificate _certificate;
    private SigningPublicKey _signingKey;
    private PublicKey _publicKey;
    private Hash __calculatedHash;

    public RouterIdentity() {
        this.setCertificate(null);
        this.setSigningPublicKey(null);
        this.setPublicKey(null);
        this.__calculatedHash = null;
    }

    public Certificate getCertificate() {
        return this._certificate;
    }

    public void setCertificate(Certificate cert) {
        this._certificate = cert;
        this.__calculatedHash = null;
    }

    public PublicKey getPublicKey() {
        return this._publicKey;
    }

    public void setPublicKey(PublicKey key) {
        this._publicKey = key;
        this.__calculatedHash = null;
    }

    public SigningPublicKey getSigningPublicKey() {
        return this._signingKey;
    }

    public void setSigningPublicKey(SigningPublicKey key) {
        this._signingKey = key;
        this.__calculatedHash = null;
    }

    public boolean isHidden() {
        return this._certificate != null && this._certificate.getCertificateType() == 2;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._publicKey = new PublicKey();
        this._publicKey.readBytes(in);
        this._signingKey = new SigningPublicKey();
        this._signingKey.readBytes(in);
        this._certificate = new Certificate();
        this._certificate.readBytes(in);
        this.__calculatedHash = null;
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._certificate == null || this._publicKey == null || this._signingKey == null) {
            throw new DataFormatException("Not enough data to format the router identity");
        }
        this._publicKey.writeBytes(out);
        this._signingKey.writeBytes(out);
        this._certificate.writeBytes(out);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RouterIdentity)) {
            return false;
        }
        RouterIdentity ident = (RouterIdentity)object;
        return DataHelper.eq(this._certificate, ident.getCertificate()) && DataHelper.eq(this._signingKey, ident.getSigningPublicKey()) && DataHelper.eq(this._publicKey, ident.getPublicKey());
    }

    public int hashCode() {
        if (this._publicKey == null) {
            return 0;
        }
        return this._publicKey.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("[RouterIdentity: ");
        buf.append("\n\tHash: ").append(this.getHash().toBase64());
        buf.append("\n\tCertificate: ").append(this.getCertificate());
        buf.append("\n\tPublicKey: ").append(this.getPublicKey());
        buf.append("\n\tSigningPublicKey: ").append(this.getSigningPublicKey());
        buf.append("]");
        return buf.toString();
    }

    public Hash calculateHash() {
        return this.getHash();
    }

    public Hash getHash() {
        if (this.__calculatedHash != null) {
            return this.__calculatedHash;
        }
        byte[] identBytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeBytes(baos);
            identBytes = baos.toByteArray();
        }
        catch (Throwable t) {
            _log.error("Error writing out hash");
            return null;
        }
        this.__calculatedHash = SHA256Generator.getInstance().calculateHash(identBytes);
        return this.__calculatedHash;
    }
}

