/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;

public class SessionIdleTimer
implements SimpleTimer.TimedEvent {
    public static final long MINIMUM_TIME = 300000L;
    private static final long DEFAULT_REDUCE_TIME = 1200000L;
    private static final long DEFAULT_CLOSE_TIME = 1800000L;
    private static final Log _log = new Log(SessionIdleTimer.class);
    private I2PAppContext _context;
    private I2PSessionImpl _session;
    private boolean _reduceEnabled;
    private int _reduceQuantity;
    private long _reduceTime;
    private boolean _shutdownEnabled;
    private long _shutdownTime;
    private long _minimumTime;
    private long _lastActive;

    public SessionIdleTimer(I2PAppContext context, I2PSessionImpl session, boolean reduce, boolean shutdown) {
        String p;
        this._context = context;
        this._session = session;
        this._reduceEnabled = reduce;
        this._shutdownEnabled = shutdown;
        if (!reduce && !shutdown) {
            throw new IllegalArgumentException("At least one must be enabled");
        }
        Properties props = session.getOptions();
        this._minimumTime = Long.MAX_VALUE;
        this._lastActive = 0L;
        if (reduce) {
            this._reduceQuantity = 1;
            p = props.getProperty("i2cp.reduceQuantity");
            if (p != null) {
                try {
                    this._reduceQuantity = Math.max(Integer.parseInt(p), 1);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            this._reduceTime = 1200000L;
            p = props.getProperty("i2cp.reduceIdleTime");
            if (p != null) {
                try {
                    this._reduceTime = Math.max(Long.parseLong(p), 300000L);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            this._minimumTime = this._reduceTime;
        }
        if (shutdown) {
            this._shutdownTime = 1800000L;
            p = props.getProperty("i2cp.closeIdleTime");
            if (p != null) {
                try {
                    this._shutdownTime = Math.max(Long.parseLong(p), 300000L);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            this._minimumTime = Math.min(this._minimumTime, this._shutdownTime);
            if (reduce && this._shutdownTime <= this._reduceTime) {
                reduce = false;
            }
        }
    }

    public void timeReached() {
        if (this._session.isClosed()) {
            return;
        }
        long now = this._context.clock().now();
        long lastActivity = this._session.lastActivity();
        if (_log.shouldLog(20)) {
            _log.info("Fire idle timer, last activity: " + DataHelper.formatDuration(now - lastActivity) + " ago ");
        }
        long nextDelay = 0L;
        if (this._shutdownEnabled && now - lastActivity >= this._shutdownTime) {
            if (_log.shouldLog(30)) {
                _log.warn("Closing on idle " + this._session);
            }
            this._session.destroySession();
            return;
        }
        if (lastActivity <= this._lastActive && !this._shutdownEnabled) {
            if (_log.shouldLog(30)) {
                _log.warn("Still idle, sleeping again " + this._session);
            }
            nextDelay = this._reduceTime;
        } else if (this._reduceEnabled && now - lastActivity >= this._reduceTime) {
            if (_log.shouldLog(30)) {
                _log.warn("Reducing quantity on idle " + this._session);
            }
            try {
                this._session.getProducer().updateTunnels(this._session, this._reduceQuantity);
            }
            catch (I2PSessionException ise) {
                _log.error("bork idle reduction " + ise);
            }
            this._session.setReduced();
            this._lastActive = lastActivity;
            nextDelay = this._shutdownEnabled ? this._shutdownTime - (now - lastActivity) : this._reduceTime;
        } else {
            nextDelay = this._minimumTime - (now - lastActivity);
        }
        SimpleScheduler.getInstance().addEvent(this, nextDelay);
    }
}

