/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.client.BWLimitsMessageHandler;
import net.i2p.client.ClientWriterRunner;
import net.i2p.client.DestReplyMessageHandler;
import net.i2p.client.I2CPMessageHandler;
import net.i2p.client.I2PClientMessageHandlerMap;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.client.I2PSessionImpl2;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.i2cp.DestLookupMessage;
import net.i2p.data.i2cp.GetBandwidthLimitsMessage;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.util.I2PThread;
import net.i2p.util.InternalSocket;

class I2PSimpleSession
extends I2PSessionImpl2 {
    private boolean _destReceived;
    private Object _destReceivedLock;
    private Destination _destination;
    private boolean _bwReceived;
    private Object _bwReceivedLock;
    private int[] _bwLimits;

    public I2PSimpleSession(I2PAppContext context, Properties options) throws I2PSessionException {
        this._context = context;
        this._log = context.logManager().getLog(I2PSimpleSession.class);
        this._handlerMap = new SimpleMessageHandlerMap(context);
        this._closed = true;
        this._closing = false;
        this._availabilityNotifier = new I2PSessionImpl.AvailabilityNotifier();
        if (options == null) {
            options = System.getProperties();
        }
        this.loadConfig(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws I2PSessionException {
        this._closed = false;
        this._availabilityNotifier.stopNotifying();
        I2PThread notifier = new I2PThread(this._availabilityNotifier);
        notifier.setName("Simple Notifier");
        notifier.setDaemon(true);
        notifier.start();
        try {
            this._socket = InternalSocket.getSocket(this._hostname, this._portNum);
            OutputStream outputStream = this._out = this._socket.getOutputStream();
            synchronized (outputStream) {
                this._out.write(42);
                this._out.flush();
            }
            this._writer = new ClientWriterRunner(this._out, this);
            InputStream in = this._socket.getInputStream();
            this._reader = new I2CPMessageReader(in, this);
            this._reader.startReading();
        }
        catch (UnknownHostException uhe) {
            this._closed = true;
            throw new I2PSessionException(this.getPrefix() + "Bad host ", uhe);
        }
        catch (IOException ioe) {
            this._closed = true;
            throw new I2PSessionException(this.getPrefix() + "Problem connecting to " + this._hostname + " on port " + this._portNum, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destReceived(Destination d) {
        this._destReceived = true;
        this._destination = d;
        Object object = this._destReceivedLock;
        synchronized (object) {
            this._destReceivedLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bwReceived(int[] i) {
        this._bwReceived = true;
        this._bwLimits = i;
        Object object = this._bwReceivedLock;
        synchronized (object) {
            this._bwReceivedLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination lookupDest(Hash h) throws I2PSessionException {
        if (this._closed) {
            return null;
        }
        this._destReceivedLock = new Object();
        this.sendMessage(new DestLookupMessage(h));
        for (int i = 0; i < 10 && !this._destReceived; ++i) {
            try {
                Object object = this._destReceivedLock;
                synchronized (object) {
                    this._destReceivedLock.wait(1000L);
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._destReceived = false;
        return this._destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] bandwidthLimits() throws I2PSessionException {
        if (this._closed) {
            return null;
        }
        this._bwReceivedLock = new Object();
        this.sendMessage(new GetBandwidthLimitsMessage());
        for (int i = 0; i < 5 && !this._bwReceived; ++i) {
            try {
                Object object = this._bwReceivedLock;
                synchronized (object) {
                    this._bwReceivedLock.wait(1000L);
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._bwReceived = false;
        return this._bwLimits;
    }

    class SimpleMessageHandlerMap
    extends I2PClientMessageHandlerMap {
        public SimpleMessageHandlerMap(I2PAppContext context) {
            int highest = Math.max(35, 23);
            this._handlers = new I2CPMessageHandler[highest + 1];
            this._handlers[35] = new DestReplyMessageHandler(context);
            this._handlers[23] = new BWLimitsMessageHandler(context);
        }
    }
}

