/*
 * Decompiled with CFR 0.152.
 */
package net.i2p;

import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import net.i2p.client.naming.NamingService;
import net.i2p.client.naming.PetNameDB;
import net.i2p.crypto.AESEngine;
import net.i2p.crypto.CryptixAESEngine;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.DummyDSAEngine;
import net.i2p.crypto.DummyElGamalEngine;
import net.i2p.crypto.ElGamalAESEngine;
import net.i2p.crypto.ElGamalEngine;
import net.i2p.crypto.HMAC256Generator;
import net.i2p.crypto.HMACGenerator;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TransientSessionKeyManager;
import net.i2p.data.RoutingKeyGenerator;
import net.i2p.stat.StatManager;
import net.i2p.util.Clock;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileUtil;
import net.i2p.util.FortunaRandomSource;
import net.i2p.util.KeyRing;
import net.i2p.util.LogManager;
import net.i2p.util.RandomSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I2PAppContext {
    protected static I2PAppContext _globalAppContext;
    private Properties _overrideProps;
    private StatManager _statManager;
    private SessionKeyManager _sessionKeyManager;
    private NamingService _namingService;
    private PetNameDB _petnameDb;
    private ElGamalEngine _elGamalEngine;
    private ElGamalAESEngine _elGamalAESEngine;
    private AESEngine _AESEngine;
    private LogManager _logManager;
    private HMACGenerator _hmac;
    private HMAC256Generator _hmac256;
    private SHA256Generator _sha;
    protected Clock _clock;
    private DSAEngine _dsa;
    private RoutingKeyGenerator _routingKeyGenerator;
    private RandomSource _random;
    private KeyGenerator _keyGenerator;
    protected KeyRing _keyRing;
    private volatile boolean _statManagerInitialized;
    private volatile boolean _sessionKeyManagerInitialized;
    private volatile boolean _namingServiceInitialized;
    private volatile boolean _petnameDbInitialized;
    private volatile boolean _elGamalEngineInitialized;
    private volatile boolean _elGamalAESEngineInitialized;
    private volatile boolean _AESEngineInitialized;
    private volatile boolean _logManagerInitialized;
    private volatile boolean _hmacInitialized;
    private volatile boolean _hmac256Initialized;
    private volatile boolean _shaInitialized;
    protected volatile boolean _clockInitialized;
    private volatile boolean _dsaInitialized;
    private volatile boolean _routingKeyGeneratorInitialized;
    private volatile boolean _randomInitialized;
    private volatile boolean _keyGeneratorInitialized;
    protected volatile boolean _keyRingInitialized;
    private Set<Runnable> _shutdownTasks;
    private File _baseDir;
    private File _configDir;
    private File _routerDir;
    private File _pidDir;
    private File _logDir;
    private File _appDir;
    private File _tmpDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static I2PAppContext getGlobalContext() {
        Class<I2PAppContext> clazz = I2PAppContext.class;
        synchronized (I2PAppContext.class) {
            if (_globalAppContext == null) {
                _globalAppContext = new I2PAppContext(false, null);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _globalAppContext;
        }
    }

    public I2PAppContext() {
        this(true, null);
    }

    public I2PAppContext(Properties envProps) {
        this(true, envProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private I2PAppContext(boolean doInit, Properties envProps) {
        if (doInit) {
            Class<I2PAppContext> clazz = I2PAppContext.class;
            // MONITORENTER : net.i2p.I2PAppContext.class
            if (_globalAppContext == null) {
                _globalAppContext = this;
            }
            // MONITOREXIT : clazz
        }
        this._overrideProps = envProps;
        this._statManager = null;
        this._sessionKeyManager = null;
        this._namingService = null;
        this._petnameDb = null;
        this._elGamalEngine = null;
        this._elGamalAESEngine = null;
        this._logManager = null;
        this._keyRing = null;
        this._statManagerInitialized = false;
        this._sessionKeyManagerInitialized = false;
        this._namingServiceInitialized = false;
        this._elGamalEngineInitialized = false;
        this._elGamalAESEngineInitialized = false;
        this._logManagerInitialized = false;
        this._keyRingInitialized = false;
        this._shutdownTasks = new ConcurrentHashSet<Runnable>(0);
        this.initializeDirs();
    }

    private void initializeDirs() {
        String s = this.getProperty("i2p.dir.base", System.getProperty("user.dir"));
        this._baseDir = new File(s);
        s = this.getProperty("i2p.dir.config");
        if (s != null) {
            this._configDir = new File(s);
            if (!this._configDir.exists()) {
                this._configDir.mkdir();
            }
        } else {
            this._configDir = this._baseDir;
        }
        if ((s = this.getProperty("i2p.dir.router")) != null) {
            this._routerDir = new File(s);
            if (!this._routerDir.exists()) {
                this._routerDir.mkdir();
            }
        } else {
            this._routerDir = this._configDir;
        }
        s = this.getProperty("i2p.dir.pid", System.getProperty("java.io.tmpdir"));
        this._pidDir = new File(s);
        if (!this._pidDir.exists()) {
            this._pidDir.mkdir();
        }
        if ((s = this.getProperty("i2p.dir.log")) != null) {
            this._logDir = new File(s);
            if (!this._logDir.exists()) {
                this._logDir.mkdir();
            }
        } else {
            this._logDir = this._routerDir;
        }
        if ((s = this.getProperty("i2p.dir.app")) != null) {
            this._appDir = new File(s);
            if (!this._appDir.exists()) {
                this._appDir.mkdir();
            }
        } else {
            this._appDir = this._routerDir;
        }
    }

    public File getBaseDir() {
        return this._baseDir;
    }

    public File getConfigDir() {
        return this._configDir;
    }

    public File getRouterDir() {
        return this._routerDir;
    }

    public File getPIDDir() {
        return this._pidDir;
    }

    public File getLogDir() {
        return this._logDir;
    }

    public File getAppDir() {
        return this._appDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getTempDir() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._tmpDir == null) {
                String d = this.getProperty("i2p.dir.temp", System.getProperty("java.io.tmpdir"));
                String f = "i2p-" + Math.abs(new Random().nextInt()) + ".tmp";
                this._tmpDir = new File(d, f);
                if (!this._tmpDir.exists()) {
                    if (this._tmpDir.mkdir()) {
                        this._tmpDir.deleteOnExit();
                    } else {
                        System.err.println("Could not create temp dir " + this._tmpDir.getAbsolutePath());
                        this._tmpDir = new File(this._routerDir, "tmp");
                        this._tmpDir.mkdir();
                    }
                }
            }
        }
        return this._tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTempDir() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._tmpDir != null) {
                FileUtil.rmdir(this._tmpDir, false);
                this._tmpDir = null;
            }
        }
    }

    public String getProperty(String propName) {
        if (this._overrideProps != null && this._overrideProps.containsKey(propName)) {
            return this._overrideProps.getProperty(propName);
        }
        return System.getProperty(propName);
    }

    public String getProperty(String propName, String defaultValue) {
        if (this._overrideProps != null && this._overrideProps.containsKey(propName)) {
            return this._overrideProps.getProperty(propName, defaultValue);
        }
        return System.getProperty(propName, defaultValue);
    }

    public int getProperty(String propName, int defaultVal) {
        String val = null;
        if (this._overrideProps != null && (val = this._overrideProps.getProperty(propName)) == null) {
            val = System.getProperty(propName);
        }
        int ival = defaultVal;
        if (val != null) {
            try {
                ival = Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return ival;
    }

    public boolean getProperty(String propName, boolean defaultVal) {
        String val = this.getProperty(propName);
        if (val == null) {
            return defaultVal;
        }
        return Boolean.valueOf(val);
    }

    public boolean getBooleanProperty(String propName) {
        return Boolean.valueOf(this.getProperty(propName));
    }

    public boolean getBooleanPropertyDefaultTrue(String propName) {
        return this.getProperty(propName, true);
    }

    public Set getPropertyNames() {
        HashSet<Object> names = new HashSet<Object>(System.getProperties().keySet());
        if (this._overrideProps != null) {
            names.addAll(this._overrideProps.keySet());
        }
        return names;
    }

    public StatManager statManager() {
        if (!this._statManagerInitialized) {
            this.initializeStatManager();
        }
        return this._statManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStatManager() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._statManager == null) {
                this._statManager = new StatManager(this);
            }
            this._statManagerInitialized = true;
        }
    }

    public SessionKeyManager sessionKeyManager() {
        if (!this._sessionKeyManagerInitialized) {
            this.initializeSessionKeyManager();
        }
        return this._sessionKeyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSessionKeyManager() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._sessionKeyManager == null) {
                this._sessionKeyManager = new TransientSessionKeyManager(this);
            }
            this._sessionKeyManagerInitialized = true;
        }
    }

    public NamingService namingService() {
        if (!this._namingServiceInitialized) {
            this.initializeNamingService();
        }
        return this._namingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNamingService() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._namingService == null) {
                this._namingService = NamingService.createInstance(this);
            }
            this._namingServiceInitialized = true;
        }
    }

    public PetNameDB petnameDb() {
        if (!this._petnameDbInitialized) {
            this.initializePetnameDb();
        }
        return this._petnameDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePetnameDb() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._petnameDb == null) {
                this._petnameDb = new PetNameDB();
            }
            this._petnameDbInitialized = true;
        }
    }

    public ElGamalEngine elGamalEngine() {
        if (!this._elGamalEngineInitialized) {
            this.initializeElGamalEngine();
        }
        return this._elGamalEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeElGamalEngine() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._elGamalEngine == null) {
                this._elGamalEngine = "off".equals(this.getProperty("i2p.encryption", "on")) ? new DummyElGamalEngine(this) : new ElGamalEngine(this);
            }
            this._elGamalEngineInitialized = true;
        }
    }

    public ElGamalAESEngine elGamalAESEngine() {
        if (!this._elGamalAESEngineInitialized) {
            this.initializeElGamalAESEngine();
        }
        return this._elGamalAESEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeElGamalAESEngine() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._elGamalAESEngine == null) {
                this._elGamalAESEngine = new ElGamalAESEngine(this);
            }
            this._elGamalAESEngineInitialized = true;
        }
    }

    public AESEngine aes() {
        if (!this._AESEngineInitialized) {
            this.initializeAESEngine();
        }
        return this._AESEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAESEngine() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._AESEngine == null) {
                this._AESEngine = "off".equals(this.getProperty("i2p.encryption", "on")) ? new AESEngine(this) : new CryptixAESEngine(this);
            }
            this._AESEngineInitialized = true;
        }
    }

    public LogManager logManager() {
        if (!this._logManagerInitialized) {
            this.initializeLogManager();
        }
        return this._logManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLogManager() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._logManager == null) {
                this._logManager = new LogManager(this);
            }
            this._logManagerInitialized = true;
        }
    }

    public HMACGenerator hmac() {
        if (!this._hmacInitialized) {
            this.initializeHMAC();
        }
        return this._hmac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeHMAC() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._hmac == null) {
                this._hmac = new HMACGenerator(this);
            }
            this._hmacInitialized = true;
        }
    }

    public HMAC256Generator hmac256() {
        if (!this._hmac256Initialized) {
            this.initializeHMAC256();
        }
        return this._hmac256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeHMAC256() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._hmac256 == null) {
                this._hmac256 = new HMAC256Generator(this);
            }
            this._hmac256Initialized = true;
        }
    }

    public SHA256Generator sha() {
        if (!this._shaInitialized) {
            this.initializeSHA();
        }
        return this._sha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSHA() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._sha == null) {
                this._sha = new SHA256Generator(this);
            }
            this._shaInitialized = true;
        }
    }

    public DSAEngine dsa() {
        if (!this._dsaInitialized) {
            this.initializeDSA();
        }
        return this._dsa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDSA() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._dsa == null) {
                this._dsa = "off".equals(this.getProperty("i2p.encryption", "on")) ? new DummyDSAEngine(this) : new DSAEngine(this);
            }
            this._dsaInitialized = true;
        }
    }

    public KeyGenerator keyGenerator() {
        if (!this._keyGeneratorInitialized) {
            this.initializeKeyGenerator();
        }
        return this._keyGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeKeyGenerator() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._keyGenerator == null) {
                this._keyGenerator = new KeyGenerator(this);
            }
            this._keyGeneratorInitialized = true;
        }
    }

    public Clock clock() {
        if (!this._clockInitialized) {
            this.initializeClock();
        }
        return this._clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeClock() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._clock == null) {
                this._clock = new Clock(this);
            }
            this._clockInitialized = true;
        }
    }

    public RoutingKeyGenerator routingKeyGenerator() {
        if (!this._routingKeyGeneratorInitialized) {
            this.initializeRoutingKeyGenerator();
        }
        return this._routingKeyGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRoutingKeyGenerator() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._routingKeyGenerator == null) {
                this._routingKeyGenerator = new RoutingKeyGenerator(this);
            }
            this._routingKeyGeneratorInitialized = true;
        }
    }

    public KeyRing keyRing() {
        if (!this._keyRingInitialized) {
            this.initializeKeyRing();
        }
        return this._keyRing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeKeyRing() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._keyRing == null) {
                this._keyRing = new KeyRing();
            }
            this._keyRingInitialized = true;
        }
    }

    public RandomSource random() {
        if (!this._randomInitialized) {
            this.initializeRandom();
        }
        return this._random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRandom() {
        I2PAppContext i2PAppContext = this;
        synchronized (i2PAppContext) {
            if (this._random == null) {
                this._random = new FortunaRandomSource(this);
            }
            this._randomInitialized = true;
        }
    }

    public void addShutdownTask(Runnable task) {
        this._shutdownTasks.add(task);
    }

    public Set<Runnable> getShutdownTasks() {
        return new HashSet<Runnable>(this._shutdownTasks);
    }

    public boolean isRouterContext() {
        return false;
    }
}

