/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.CPUInformation;

import freenet.support.CPUInformation.AMDCPUInfo;
import freenet.support.CPUInformation.CPUInfo;
import freenet.support.CPUInformation.IntelCPUInfo;
import freenet.support.CPUInformation.UnknownCPUException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.i2p.I2PAppContext;
import net.i2p.util.FileUtil;

public class CPUID {
    private static boolean _nativeOk = false;
    private static final boolean _doLog = System.getProperty("jcpuid.dontLog") == null;
    private static final boolean isX86 = -1 != System.getProperty("os.arch").indexOf("86");
    private static final String libPrefix = System.getProperty("os.name").startsWith("Win") ? "" : "lib";
    private static final String libSuffix = System.getProperty("os.name").startsWith("Win") ? ".dll" : ".so";

    private static native CPUIDResult doCPUID(int var0);

    private static String getCPUVendorID() {
        CPUIDResult c = CPUID.doCPUID(0);
        StringBuilder sb = new StringBuilder(13);
        sb.append((char)(c.EBX & 0xFF));
        sb.append((char)(c.EBX >> 8 & 0xFF));
        sb.append((char)(c.EBX >> 16 & 0xFF));
        sb.append((char)(c.EBX >> 24 & 0xFF));
        sb.append((char)(c.EDX & 0xFF));
        sb.append((char)(c.EDX >> 8 & 0xFF));
        sb.append((char)(c.EDX >> 16 & 0xFF));
        sb.append((char)(c.EDX >> 24 & 0xFF));
        sb.append((char)(c.ECX & 0xFF));
        sb.append((char)(c.ECX >> 8 & 0xFF));
        sb.append((char)(c.ECX >> 16 & 0xFF));
        sb.append((char)(c.ECX >> 24 & 0xFF));
        return sb.toString();
    }

    private static int getCPUFamily() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 8 & 0xF;
    }

    private static int getCPUModel() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 4 & 0xF;
    }

    private static int getCPUExtendedModel() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 16 & 0xF;
    }

    private static int getCPUType() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 12 & 0xF;
    }

    private static int getCPUExtendedFamily() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX >> 20 & 0xFF;
    }

    private static int getCPUStepping() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EAX & 0xF;
    }

    private static int getCPUFlags() {
        CPUIDResult c = CPUID.doCPUID(1);
        return c.EDX;
    }

    public static CPUInfo getInfo() throws UnknownCPUException {
        if (!_nativeOk) {
            throw new UnknownCPUException("Failed to read CPU information from the system. Please verify the existence of the jcpuid dll/so.");
        }
        if (CPUID.getCPUVendorID().equals("CentaurHauls")) {
            return new VIAC3Impl();
        }
        if (!isX86) {
            throw new UnknownCPUException("Failed to read CPU information from the system. The CPUID instruction exists on x86 CPU's only");
        }
        if (CPUID.getCPUVendorID().equals("AuthenticAMD")) {
            return new AMDInfoImpl();
        }
        if (CPUID.getCPUVendorID().equals("GenuineIntel")) {
            return new IntelInfoImpl();
        }
        throw new UnknownCPUException("Unknown CPU type: '" + CPUID.getCPUVendorID() + "'");
    }

    public static void main(String[] args) {
        if (!_nativeOk) {
            System.out.println("**Failed to retrieve CPUInfo. Please verify the existence of jcpuid dll/so**");
        }
        System.out.println("**CPUInfo**");
        System.out.println("CPU Vendor: " + CPUID.getCPUVendorID());
        System.out.println("CPU Family: " + CPUID.getCPUFamily());
        System.out.println("CPU Model: " + CPUID.getCPUModel());
        System.out.println("CPU Stepping: " + CPUID.getCPUStepping());
        System.out.println("CPU Flags: " + CPUID.getCPUFlags());
        CPUInfo c = CPUID.getInfo();
        System.out.println(" **More CPUInfo**");
        System.out.println(" CPU model string: " + c.getCPUModelString());
        System.out.println(" CPU has MMX: " + c.hasMMX());
        System.out.println(" CPU has SSE: " + c.hasSSE());
        System.out.println(" CPU has SSE2: " + c.hasSSE2());
        if (c instanceof IntelCPUInfo) {
            System.out.println("  **Intel-info**");
            System.out.println("  Is pII-compatible: " + ((IntelCPUInfo)c).IsPentium2Compatible());
            System.out.println("  Is pIII-compatible: " + ((IntelCPUInfo)c).IsPentium3Compatible());
            System.out.println("  Is pIV-compatible: " + ((IntelCPUInfo)c).IsPentium4Compatible());
        }
        if (c instanceof AMDCPUInfo) {
            System.out.println("  **AMD-info**");
            System.out.println("  Is Athlon-compatible: " + ((AMDCPUInfo)c).IsAthlonCompatible());
        }
    }

    private static final void loadNative() {
        block12: {
            try {
                String wantedProp = System.getProperty("jcpuid.enable", "true");
                boolean wantNative = "true".equalsIgnoreCase(wantedProp);
                if (wantNative) {
                    boolean loaded = CPUID.loadGeneric();
                    if (loaded) {
                        _nativeOk = true;
                        if (_doLog) {
                            System.err.println("INFO: Native CPUID library '" + CPUID.getLibraryMiddlePart() + "' loaded from somewhere in the path");
                        }
                    } else {
                        loaded = CPUID.loadFromResource();
                        if (loaded) {
                            _nativeOk = true;
                            if (_doLog) {
                                System.err.println("INFO: Native CPUID library '" + CPUID.getResourceName() + "' loaded from resource");
                            }
                        } else {
                            _nativeOk = false;
                            if (_doLog) {
                                System.err.println("WARN: Native CPUID library jcpuid not loaded - will not be able to read CPU information using CPUID");
                            }
                        }
                    }
                } else if (_doLog) {
                    System.err.println("INFO: Native CPUID library jcpuid not loaded - will not be able to read CPU information using CPUID");
                }
            }
            catch (Exception e) {
                if (!_doLog) break block12;
                System.err.println("INFO: Native CPUID library jcpuid not loaded, reason: '" + e.getMessage() + "' - will not be able to read CPU information using CPUID");
            }
        }
    }

    private static final boolean loadGeneric() {
        try {
            System.loadLibrary("jcpuid");
            return true;
        }
        catch (UnsatisfiedLinkError ule) {
            try {
                System.loadLibrary(CPUID.getLibraryMiddlePart());
                return true;
            }
            catch (UnsatisfiedLinkError ule2) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean loadFromResource() {
        String resourceName = CPUID.getResourceName();
        if (resourceName == null) {
            return false;
        }
        URL resource = CPUID.class.getClassLoader().getResource(resourceName);
        if (resource == null) {
            if (_doLog) {
                System.err.println("ERROR: Resource name [" + resourceName + "] was not found");
            }
            return false;
        }
        File outFile = null;
        FileOutputStream fos = null;
        String filename = libPrefix + "jcpuid" + libSuffix;
        try {
            int read;
            InputStream libStream = resource.openStream();
            outFile = new File(I2PAppContext.getGlobalContext().getTempDir(), filename);
            fos = new FileOutputStream(outFile);
            byte[] buf = new byte[4096];
            while ((read = libStream.read(buf)) >= 0) {
                fos.write(buf, 0, read);
            }
            fos.close();
            fos = null;
            System.load(outFile.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError ule) {
            if (_doLog) {
                System.err.println("ERROR: The resource " + resourceName + " was not a valid library for this platform");
                ule.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            if (_doLog) {
                System.err.println("ERROR: Problem writing out the temporary native library data");
                ioe.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
        File newFile = new File(I2PAppContext.getGlobalContext().getBaseDir(), filename);
        FileUtil.copy(outFile.getAbsolutePath(), newFile.getAbsolutePath(), false, true);
        return true;
    }

    private static final String getResourceName() {
        return CPUID.getLibraryPrefix() + CPUID.getLibraryMiddlePart() + "." + CPUID.getLibrarySuffix();
    }

    private static final String getLibraryPrefix() {
        boolean isWindows;
        boolean bl = isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        if (isWindows) {
            return "";
        }
        return "lib";
    }

    private static final String getLibraryMiddlePart() {
        boolean isFreebsd;
        boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("linux") != -1;
        boolean bl = isFreebsd = System.getProperty("os.name").toLowerCase().indexOf("freebsd") != -1;
        if (isWindows) {
            return "jcpuid-x86-windows";
        }
        if (isLinux) {
            return "jcpuid-x86-linux";
        }
        if (isFreebsd) {
            return "jcpuid-x86-freebsd";
        }
        throw new RuntimeException("Dont know jcpuid library name for os type '" + System.getProperty("os.name") + "'");
    }

    private static final String getLibrarySuffix() {
        boolean isWindows;
        boolean bl = isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        if (isWindows) {
            return "dll";
        }
        return "so";
    }

    static {
        CPUID.loadNative();
    }

    protected static class IntelInfoImpl
    extends CPUIDCPUInfo
    implements IntelCPUInfo {
        protected IntelInfoImpl() {
        }

        public boolean IsPentiumCompatible() {
            return CPUID.getCPUFamily() >= 5;
        }

        public boolean IsPentiumMMXCompatible() {
            return this.IsPentium2Compatible() || CPUID.getCPUFamily() == 5 && (CPUID.getCPUModel() == 4 || CPUID.getCPUModel() == 8);
        }

        public boolean IsPentium2Compatible() {
            return CPUID.getCPUFamily() > 6 || CPUID.getCPUFamily() == 6 && CPUID.getCPUModel() >= 3;
        }

        public boolean IsPentium3Compatible() {
            return CPUID.getCPUFamily() > 6 || CPUID.getCPUFamily() == 6 && CPUID.getCPUModel() >= 7;
        }

        public boolean IsPentium4Compatible() {
            return CPUID.getCPUFamily() >= 15;
        }

        public String getCPUModelString() throws UnknownCPUException {
            if (CPUID.getCPUFamily() == 4) {
                switch (CPUID.getCPUModel()) {
                    case 0: {
                        return "486 DX-25/33";
                    }
                    case 1: {
                        return "486 DX-50";
                    }
                    case 2: {
                        return "486 SX";
                    }
                    case 3: {
                        return "486 DX/2";
                    }
                    case 4: {
                        return "486 SL";
                    }
                    case 5: {
                        return "486 SX/2";
                    }
                    case 7: {
                        return "486 DX/2-WB";
                    }
                    case 8: {
                        return "486 DX/4";
                    }
                    case 9: {
                        return "486 DX/4-WB";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 5) {
                switch (CPUID.getCPUModel()) {
                    case 0: {
                        return "Pentium 60/66 A-step";
                    }
                    case 1: {
                        return "Pentium 60/66";
                    }
                    case 2: {
                        return "Pentium 75 - 200";
                    }
                    case 3: {
                        return "OverDrive PODP5V83";
                    }
                    case 4: {
                        return "Pentium MMX";
                    }
                    case 7: {
                        return "Mobile Pentium 75 - 200";
                    }
                    case 8: {
                        return "Mobile Pentium MMX";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 6) {
                switch (CPUID.getCPUModel()) {
                    case 0: {
                        return "Pentium Pro A-step";
                    }
                    case 1: {
                        return "Pentium Pro";
                    }
                    case 3: {
                        return "Pentium II (Klamath)";
                    }
                    case 5: {
                        return "Pentium II (Deschutes), Celeron (Covington), Mobile Pentium II (Dixon)";
                    }
                    case 6: {
                        return "Mobile Pentium II, Celeron (Mendocino)";
                    }
                    case 7: {
                        return "Pentium III (Katmai)";
                    }
                    case 8: {
                        return "Pentium III (Coppermine), Celeron w/SSE";
                    }
                    case 9: {
                        return "Mobile Pentium III";
                    }
                    case 10: {
                        return "Pentium III Xeon (Cascades)";
                    }
                    case 11: {
                        return "Pentium III (130 nm)";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 7) {
                CPUID.getCPUModel();
            }
            if (CPUID.getCPUFamily() == 15) {
                if (CPUID.getCPUExtendedFamily() == 0) {
                    switch (CPUID.getCPUModel()) {
                        case 0: {
                            return "Pentium IV (180 nm)";
                        }
                        case 1: {
                            return "Pentium IV (180 nm)";
                        }
                        case 2: {
                            return "Pentium IV (130 nm)";
                        }
                        case 3: {
                            return "Pentium IV (90 nm)";
                        }
                    }
                }
                if (CPUID.getCPUExtendedFamily() == 1) {
                    CPUID.getCPUModel();
                }
            }
            throw new UnknownCPUException("Unknown Intel CPU; Family=" + CPUID.getCPUFamily() + ", Model=" + CPUID.getCPUModel());
        }
    }

    protected static class AMDInfoImpl
    extends CPUIDCPUInfo
    implements AMDCPUInfo {
        protected AMDInfoImpl() {
        }

        public boolean IsK6Compatible() {
            return CPUID.getCPUFamily() >= 5 && CPUID.getCPUModel() >= 6;
        }

        public boolean IsK6_2_Compatible() {
            return CPUID.getCPUFamily() >= 5 && CPUID.getCPUModel() >= 8;
        }

        public boolean IsK6_3_Compatible() {
            return CPUID.getCPUFamily() >= 5 && CPUID.getCPUModel() >= 9;
        }

        public boolean IsAthlonCompatible() {
            return CPUID.getCPUFamily() >= 6;
        }

        public boolean IsAthlon64Compatible() {
            return CPUID.getCPUFamily() == 15 && CPUID.getCPUExtendedFamily() == 0;
        }

        public String getCPUModelString() throws UnknownCPUException {
            if (CPUID.getCPUFamily() == 4) {
                switch (CPUID.getCPUModel()) {
                    case 3: {
                        return "486 DX/2";
                    }
                    case 7: {
                        return "486 DX/2-WB";
                    }
                    case 8: {
                        return "486 DX/4";
                    }
                    case 9: {
                        return "486 DX/4-WB";
                    }
                    case 14: {
                        return "Am5x86-WT";
                    }
                    case 15: {
                        return "Am5x86-WB";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 5) {
                switch (CPUID.getCPUModel()) {
                    case 0: {
                        return "K5/SSA5";
                    }
                    case 1: {
                        return "K5";
                    }
                    case 2: {
                        return "K5";
                    }
                    case 3: {
                        return "K5";
                    }
                    case 6: {
                        return "K6";
                    }
                    case 7: {
                        return "K6";
                    }
                    case 8: {
                        return "K6-2";
                    }
                    case 9: {
                        return "K6-3";
                    }
                    case 13: {
                        return "K6-2+ or K6-III+";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 6) {
                switch (CPUID.getCPUModel()) {
                    case 0: {
                        return "Athlon (250 nm)";
                    }
                    case 1: {
                        return "Athlon (250 nm)";
                    }
                    case 2: {
                        return "Athlon (180 nm)";
                    }
                    case 3: {
                        return "Duron";
                    }
                    case 4: {
                        return "Athlon (Thunderbird)";
                    }
                    case 6: {
                        return "Athlon (Palamino)";
                    }
                    case 7: {
                        return "Duron (Morgan)";
                    }
                    case 8: {
                        return "Athlon (Thoroughbred)";
                    }
                    case 10: {
                        return "Athlon (Barton)";
                    }
                }
            }
            if (CPUID.getCPUFamily() == 15 && CPUID.getCPUExtendedFamily() == 0) {
                switch (CPUID.getCPUModel()) {
                    case 4: {
                        return "Athlon 64";
                    }
                    case 5: {
                        return "Athlon 64 FX Opteron";
                    }
                    case 12: {
                        return "Athlon 64";
                    }
                }
                return "Athlon 64 (unknown)";
            }
            throw new UnknownCPUException("Unknown AMD CPU; Family=" + CPUID.getCPUFamily() + ", Model=" + CPUID.getCPUModel());
        }
    }

    protected static class VIAC3Impl
    extends CPUIDCPUInfo
    implements CPUInfo {
        protected VIAC3Impl() {
        }

        public boolean IsC3Compatible() {
            return true;
        }

        public String getCPUModelString() {
            return "VIA C3";
        }
    }

    protected static abstract class CPUIDCPUInfo {
        protected CPUIDCPUInfo() {
        }

        public String getVendor() {
            return CPUID.getCPUVendorID();
        }

        public boolean hasMMX() {
            return (CPUID.getCPUFlags() & 0x800000) > 0;
        }

        public boolean hasSSE() {
            return (CPUID.getCPUFlags() & 0x2000000) > 0;
        }

        public boolean hasSSE2() {
            return (CPUID.getCPUFlags() & 0x4000000) > 0;
        }

        public boolean IsC3Compatible() {
            return false;
        }
    }

    protected static class CPUIDResult {
        final int EAX;
        final int EBX;
        final int ECX;
        final int EDX;

        CPUIDResult(int EAX, int EBX, int ECX, int EDX) {
            this.EAX = EAX;
            this.EBX = EBX;
            this.ECX = ECX;
            this.EDX = EDX;
        }
    }
}

