/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Comparator;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionComparator
implements Comparator<String> {
    private static final String VALID_SEPARATOR_CHARS = ".-_";
    private static final String VALID_VERSION_CHARS = "0123456789.-_";

    @Override
    public int compare(String l, String r) {
        if (l.equals(r)) {
            return 0;
        }
        StringTokenizer lTokens = new StringTokenizer(VersionComparator.sanitize(l), VALID_SEPARATOR_CHARS);
        StringTokenizer rTokens = new StringTokenizer(VersionComparator.sanitize(r), VALID_SEPARATOR_CHARS);
        while (lTokens.hasMoreTokens() && rTokens.hasMoreTokens()) {
            String rNumber;
            String lNumber = lTokens.nextToken();
            int diff = VersionComparator.intCompare(lNumber, rNumber = rTokens.nextToken());
            if (diff == 0) continue;
            return diff;
        }
        if (lTokens.hasMoreTokens() && !rTokens.hasMoreTokens()) {
            return 1;
        }
        if (rTokens.hasMoreTokens() && !lTokens.hasMoreTokens()) {
            return -1;
        }
        return 0;
    }

    private static final int intCompare(String lop, String rop) {
        int right;
        int left;
        try {
            left = Integer.parseInt(lop);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
        try {
            right = Integer.parseInt(rop);
        }
        catch (NumberFormatException nfe) {
            return 1;
        }
        return left - right;
    }

    private static final String sanitize(String versionString) {
        StringBuilder versionStringBuilder = new StringBuilder(versionString);
        for (int i = 0; i < versionStringBuilder.length(); ++i) {
            if (VALID_VERSION_CHARS.indexOf(versionStringBuilder.charAt(i)) != -1) continue;
            versionStringBuilder.deleteCharAt(i);
            --i;
        }
        return versionStringBuilder.toString();
    }
}

