/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.SSLSocketFactory;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.EepGet;
import net.i2p.util.SocketTimeout;

public class SSLEepGet
extends EepGet {
    public SSLEepGet(I2PAppContext ctx, OutputStream outputStream, String url) {
        super(ctx, false, null, -1, 0, -1L, -1L, null, outputStream, url, true, null, null);
    }

    public static void main(String[] args) {
        SSLEepGet get;
        FileOutputStream out;
        String url = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    SSLEepGet.usage();
                    return;
                }
                url = args[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SSLEepGet.usage();
            return;
        }
        if (url == null) {
            SSLEepGet.usage();
            return;
        }
        String saveAs = SSLEepGet.suggestName(url);
        try {
            out = new FileOutputStream(saveAs);
        }
        catch (IOException ioe) {
            System.err.println("Failed to create output file " + saveAs);
            return;
        }
        SSLEepGet sSLEepGet = get = new SSLEepGet(I2PAppContext.getGlobalContext(), out, url);
        sSLEepGet.getClass();
        get.addStatusListener(sSLEepGet.new EepGet.CLIStatusListener(1024, 40));
        get.fetch(45000L, -1L, 60000L);
    }

    private static void usage() {
        System.err.println("SSLEepGet url");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFetch(SocketTimeout timeout) throws IOException {
        int i;
        this._headersRead = false;
        this._aborted = false;
        try {
            this.readHeaders();
        }
        finally {
            this._headersRead = true;
        }
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP headers");
        }
        timeout.resetTimer();
        if (this._fetchInactivityTimeout > 0L) {
            timeout.setInactivityTimeout(this._fetchInactivityTimeout);
        } else {
            timeout.setInactivityTimeout(60000L);
        }
        if (this._redirectLocation != null) {
            throw new IOException("Server redirect to " + this._redirectLocation + " not allowed");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Headers read completely, reading " + this._bytesRemaining);
        }
        boolean strictSize = this._bytesRemaining >= 0L;
        int remaining = (int)this._bytesRemaining;
        byte[] buf = new byte[1024];
        while (!(!this._keepFetching || remaining <= 0 && strictSize || this._aborted)) {
            int read;
            int toRead = buf.length;
            if (strictSize && toRead > remaining) {
                toRead = remaining;
            }
            if ((read = this._proxyIn.read(buf, 0, toRead)) == -1) break;
            timeout.resetTimer();
            this._out.write(buf, 0, read);
            this._bytesTransferred += (long)read;
            if ((remaining -= read) == 0 && this._encodingChunked) {
                int char1 = this._proxyIn.read();
                if (char1 == 13) {
                    int char2 = this._proxyIn.read();
                    if (char2 == 10) {
                        remaining = (int)this.readChunkLength();
                    } else {
                        this._out.write(char1);
                        this._out.write(char2);
                        this._bytesTransferred += 2L;
                        remaining -= 2;
                        read += 2;
                    }
                } else {
                    this._out.write(char1);
                    ++this._bytesTransferred;
                    --remaining;
                    ++read;
                }
            }
            timeout.resetTimer();
            if (this._bytesRemaining >= (long)read) {
                this._bytesRemaining -= (long)read;
            }
            if (read <= 0) continue;
            for (int i2 = 0; i2 < this._listeners.size(); ++i2) {
                ((EepGet.StatusListener)this._listeners.get(i2)).bytesTransferred(this._alreadyTransferred, read, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url);
            }
            this._alreadyTransferred += (long)read;
        }
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP data");
        }
        timeout.cancel();
        if (this._transferFailed) {
            for (i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).attemptFailed(this._url, this._bytesTransferred, this._bytesRemaining, this._currentAttempt, this._numRetries, new Exception("Attempt failed"));
            }
        } else if (this._bytesRemaining == -1L || remaining == 0) {
            for (i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).transferComplete(this._alreadyTransferred, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url, this._outputFile, this._notModified);
            }
        } else {
            throw new IOException("Disconnection on attempt " + this._currentAttempt + " after " + this._bytesTransferred);
        }
    }

    protected void sendRequest(SocketTimeout timeout) throws IOException {
        File outFile;
        if (this._outputStream == null && (outFile = new File(this._outputFile)).exists()) {
            this._alreadyTransferred = outFile.length();
        }
        String req = this.getRequest();
        try {
            int port;
            String host;
            URL url = new URL(this._actualURL);
            if ("https".equals(url.getProtocol())) {
                host = url.getHost();
                port = url.getPort();
                if (port == -1) {
                    port = 443;
                }
            } else {
                throw new IOException("Only https supported: " + this._actualURL);
            }
            this._proxy = SSLSocketFactory.getDefault().createSocket(host, port);
        }
        catch (MalformedURLException mue) {
            throw new IOException("Request URL is invalid");
        }
        this._proxyIn = this._proxy.getInputStream();
        this._proxyOut = this._proxy.getOutputStream();
        this._proxyOut.write(DataHelper.getUTF8(req));
        this._proxyOut.flush();
        if (this._log.shouldLog(10)) {
            this._log.debug("Request flushed");
        }
    }
}

