/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.zip.GZIPOutputStream;
import net.i2p.data.DataHelper;
import net.i2p.util.ResettableGZIPInputStream;

public class ReusableGZIPInputStream
extends ResettableGZIPInputStream {
    private static final ArrayList _available = new ArrayList(8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReusableGZIPInputStream acquire() {
        ReusableGZIPInputStream rv = null;
        ArrayList arrayList = _available;
        synchronized (arrayList) {
            if (_available.size() > 0) {
                rv = (ReusableGZIPInputStream)_available.remove(0);
            }
        }
        if (rv == null) {
            rv = new ReusableGZIPInputStream();
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(ReusableGZIPInputStream released) {
        ArrayList arrayList = _available;
        synchronized (arrayList) {
            if (_available.size() < 8) {
                _available.add(released);
            }
        }
    }

    private ReusableGZIPInputStream() {
    }

    public static void main(String[] args) {
        int i;
        for (i = 0; i < 2; ++i) {
            ReusableGZIPInputStream.test();
        }
        for (i = 0; i < 65536 && ReusableGZIPInputStream.test(i); ++i) {
        }
    }

    private static void test() {
        byte[] b = "hi, how are you today?".getBytes();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(64);
            GZIPOutputStream o = new GZIPOutputStream(baos);
            o.write(b);
            o.finish();
            o.flush();
            byte[] compressed = baos.toByteArray();
            ReusableGZIPInputStream in = ReusableGZIPInputStream.acquire();
            in.initialize(new ByteArrayInputStream(compressed));
            byte[] rv = new byte[128];
            int read = in.read(rv);
            if (!DataHelper.eq(rv, 0, b, 0, b.length)) {
                throw new RuntimeException("foo, read=" + read);
            }
            System.out.println("match, w00t");
            ReusableGZIPInputStream.release(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean test(int size) {
        byte[] b = new byte[size];
        new Random().nextBytes(b);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
            GZIPOutputStream o = new GZIPOutputStream(baos);
            o.write(b);
            o.finish();
            o.flush();
            byte[] compressed = baos.toByteArray();
            ReusableGZIPInputStream in = ReusableGZIPInputStream.acquire();
            in.initialize(new ByteArrayInputStream(compressed));
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream(size);
            byte[] rbuf = new byte[128];
            try {
                int read;
                while ((read = in.read(rbuf)) != -1) {
                    baos2.write(rbuf, 0, read);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                long crcVal = in.getCurrentCRCVal();
                throw ioe;
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                throw re;
            }
            ReusableGZIPInputStream.release(in);
            byte[] rv = baos2.toByteArray();
            if (rv.length != b.length) {
                throw new RuntimeException("read length: " + rv.length + " expected: " + b.length);
            }
            if (!DataHelper.eq(rv, 0, b, 0, b.length)) {
                throw new RuntimeException("foo, read=" + rv.length);
            }
            System.out.println("match, w00t");
            return true;
        }
        catch (Exception e) {
            System.out.println("Error dealing with size=" + size + ": " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

